function prepare_transition(Env,par,D)

global modelOptions;

LengthOfTransition = 250;

if modelOptions.experiment == 0
    modFilePathIn = 'transitions/welfare_in.mod';
    modFilePathOut = 'scratch/transition.mod';
    mat_out = 'scratch/transition_input.mat';
    prep(modFilePathIn,modFilePathOut,mat_out,LengthOfTransition,Env,par,D)
    

    modFilePathIn = 'transitions/ZLB_in.mod';
    modFilePathOut = 'scratch/transition_ZLB.mod';
    mat_out = 'scratch/transition_input_ZLB.mat';
    prep(modFilePathIn,modFilePathOut,mat_out,LengthOfTransition,Env,par,D)

    modFilePathIn = 'transitions/Steady2Steady_initval_block.mod'
    modFilePathOut = 'scratch/Steady2Steady_initval_block.mod';
    
    writeModFile(modFilePathIn,modFilePathOut,Env,par,D,8);
    save('scratch/D0.mat','D')
    
elseif modelOptions.experiment == 1
    
    modFilePathIn = 'transitions/welfare_LowStab_in.mod';
    modFilePathOut = 'scratch/transition.mod';
    mat_out = 'scratch/transition_input.mat';
    prep(modFilePathIn,modFilePathOut,mat_out,LengthOfTransition,Env,par,D)
    
    modFilePathIn = 'transitions/ZLB_LowStab_in.mod';
    modFilePathOut = 'scratch/transition_ZLB.mod';
    mat_out = 'scratch/transition_input_ZLB.mat';
    prep(modFilePathIn,modFilePathOut,mat_out,LengthOfTransition,Env,par,D)
   
    
    modFilePathIn = 'transitions/Steady2Steady_in.mod';
    modFilePathOut = 'scratch/Steady2Steady.mod';
    writeModFile(modFilePathIn,modFilePathOut,Env,par,D,8);

end




end

function prep(modFilePathIn,modFilePathOut,mat_out,LengthOfTransition,Env,par,D)

global Params modelOptions;


writeModFile(modFilePathIn,modFilePathOut,Env,par,D,8);
save('scratch/HhldEnv.mat','Env','par','D','Params','modelOptions')
createDynareInputMat(modFilePathOut,mat_out,LengthOfTransition)
pause(1)
C = strsplit(mat_out,'/');
copyfile(mat_out,[C{1} '/orig_' C{2}])


end