function dist = relaxUpdate(relax)





load('transition_input.mat','betashock', 'laborMarketStatus','z','mpshock','markupshock')
load Exog.mat;  %loads the star versions of the above.  These are the target values that we are moving towards


%check inputs
assert(size(betashock,2) == 1)
assert(size(betashockstar,2) == 1)


%put all data in matrices
curr = [betashock laborMarketStatus z mpshock markupshock];
star = [betashockstar laborMarketStatusstar zstar mpshockstar markupshockstar];

clear betashock laborMarketStatus z mpshock markupshock betashockstar laborMarketStatusstar zstar mpshockstar markupshockstar;


%find the distance between current values for exogenous sequences and the
%target (star) sequences
[dist, I] = max(abs(curr(2,:)-star(2,:)));
if dist > 1e-8
    dist = dist/abs(star(2,I)-star(end,I));
end
clear I;


%Update the exogenous processes
new = (1-relax) * curr + relax * star;
clear curr star;


%unpack matrices
betashock = new(:,1);
laborMarketStatus = new(:,2);
z = new(:,3);
mpshock = new(:,4);
markupshock = new(:,5);
clear new;


save('transition_input.mat', 'betashock', 'laborMarketStatus','z','mpshock','markupshock', '-append')


end