clear all;
close all;
clc;

shocks(1).name = 'z';
shocks(1).name_desc = 'Technology shock';

shocks(2).name = 'mp';
shocks(2).name_desc = 'Monetary policy shock';

shocks(3).name = 'markup';
shocks(3).name_desc = 'Markup shock';

shocks(4).name = 'ZLB';
shocks(4).name_desc = 'ZLB';

for i = 1:length(shocks)
    
    try
        experiment = '0';
        [shocks(i).base.iw, shocks(i).base.wa, shocks(i).base.ut, shocks(i).base.ve] = dwelfare(experiment, shocks(i).name);
        
        experiment = '1';
        [shocks(i).exp1.iw, shocks(i).exp1.wa, shocks(i).exp1.ut, shocks(i).exp1.ve] = dwelfare(experiment, shocks(i).name);
        
        shocks(i).diff = shocks(i).base;
        
        shocks(i).diff.iw.w10 = shocks(i).exp1.iw.w10 - shocks(i).base.iw.w10;
        shocks(i).diff.iw.w25 = shocks(i).exp1.iw.w25 - shocks(i).base.iw.w25;
        shocks(i).diff.iw.w50 = shocks(i).exp1.iw.w50 - shocks(i).base.iw.w50;
        shocks(i).diff.iw.w75 = shocks(i).exp1.iw.w75 - shocks(i).base.iw.w75;
        shocks(i).diff.iw.w90 = shocks(i).exp1.iw.w90 - shocks(i).base.iw.w90;
        
        shocks(i).diff.wa.dChangeConsEquiv = shocks(i).exp1.wa.dChangeConsEquiv - shocks(i).base.wa.dChangeConsEquiv;
        
        shocks(i).diff.ut.dChangeConsEquiv = shocks(i).exp1.ut.dChangeConsEquiv - shocks(i).base.ut.dChangeConsEquiv;
        
        shocks(i).diff.ve = shocks(i).exp1.ve - shocks(i).base.ve;
    catch me
        if ~isempty(strfind(me.message,'vspline'))
            error('Path not set.')
        else
            rethrow(me)
        end
    end
end



%% write to latex
fname = 'welfare_tables.tex';
fid= fopen(fname,'w');
wr = @(str)(fprintf(fid,'%s\n',str));


%print the header
wr('\documentclass[letterpaper,notitlepage,12pt,letterpaper]{article} \usepackage{fullpage}  \usepackage{booktabs,caption,fixltx2e} \begin{document}');

exper = {'Baseline', 'Low stabilizers', 'Difference'};

for i = 1:length(shocks)
    
    
    wr(['\section{' shocks(i).name_desc '}']);
    wr(' ');
    
    for j = 1:length(exper)
        
        if strcmp(exper{j},'Baseline')
            t = shocks(i).base;
        elseif strcmp(exper{j},'Low stabilizers')
            t = shocks(i).exp1;
        elseif strcmp(exper{j},'Difference')
            t = shocks(i).diff;
        else
            error('unrecognized experiment name')
        end
        
        wr(['\subsection{' exper{j} '}']);
        wr(' ');
        
        
        wr(['Patient welfare: ' num2str(t.ve)]);
        wr('\\ ');
        
        wr('Select income and wealth combinations');
        wr(' ');
        wr(table2latex(t.iw));
        wr(' ');
        
        wr('Weighted average across wealth conditional on income');
        wr(' ');
        wr(table2latex(t.wa));
        wr(' ');
        
        wr('Utilitarian');
        wr(' ');
        wr(table2latex(t.ut));
        wr(' ');
        
        wr('\clearpage');
        wr(' ');
    end
end



%% Steady 2 Steady
[iwTable, waTable, utilitarian,dve] = dwelfare('0', 'Steady2Steady' );      


wr('\section{Transition between steady states.  All stabilizers reduced.}');

wr(['Change in patient welfare: ' num2str(dve)]);
wr('\\ ');

wr(table2latex(iwTable));
wr(' ');

wr(table2latex(waTable));
wr(' ');

wr(table2latex(utilitarian));
wr(' ');

wr('\clearpage');
wr(' ');

wr('\end{document}');

fclose(fid);
