
function [iwTable, waTable, utilitarian,dve] = dwelfare(experiment, shock)


if verLessThan('matlab','8.2.0')
    error('Need newer matlab to use table command.')
end


PATH_TO_MAT_FILES = 'transitions/results/';

betah = 0.978961862738;
betae = 0.988830128237;
nu = 4;

% load baseline and experiment data
[V,ve,D,wealth_grid] = loadVD(PATH_TO_MAT_FILES,experiment,'noshock');
[Vhat,vehat,Dhat] = loadVD(PATH_TO_MAT_FILES,experiment,shock);

assert( max(abs(D(:) - Dhat(:))) < 1e-10);
clear Dhat;


%
% %compute change in welfare for each node
dve = exp((1-betae)*(vehat - ve)) - 1;




% Make table over ip and wealth
wealthPcts = [0.1 0.25 0.5 0.75 0.9];
tabData = tableLookup(V,D,wealthPcts);
tabDatahat = tableLookup(Vhat,D,wealthPcts);
dtabData = exp((1-betah)*(tabDatahat-tabData))-1;


npp = size(D,2);
iwTable = table(kron([1; 2; 3], ones(npp/3,1)),kron(ones(npp/3,1),[1;2;3]),'VariableNames',{'employment', 'skill'});
for iwealth = 1:length(wealthPcts)
    iwTable = [iwTable table(dtabData(:,iwealth),'VariableNames',{['w' num2str(100*wealthPcts(iwealth))]})];
end



%average impact by income type
wadat = zeros(npp,1);
for ip = 1:npp
    mask = false(1,npp);
    mask(ip) = true;
    wadat(ip) = exp((1-betah)*(weightedAverage(Vhat,D,mask)-weightedAverage(V,D,mask)))-1;
end
waTable = table(kron([1; 2; 3], ones(npp/3,1)),kron(ones(npp/3,1),[1;2;3]),sum(D)',wadat,'VariableNames',{'employment', 'skill','mass','dChangeConsEquiv'});


%Utilitarian
utildat = zeros(1,3);
utildat(1,1) = (weightedAverage(V,D)*nu + ve)/(1+nu);
utildat(1,2) = (weightedAverage(Vhat,D)*nu + vehat)/(1+nu);
utildat(1,3) = exp((1-betah)*(utildat(1,2) - utildat(1,1)))-1;



utilitarian = table(utildat(:,3),'VariableNames',{'dChangeConsEquiv'});

end


