
function [VonD,ve,D,wealth_grid] = loadVD(PATH,experiment,shock)
%loads the data from disk and interpolates onto a finer grid (ie the grid
%for assets)

global Params;

if strcmp(shock,'noshock')
    fname = [PATH 'transition_exp' experiment '_z.mat'];
    disp(['Loading: ' fname])
    load(fname,'ve')
    ve = ve(end);  %last value is steady state value
else
    fname = [PATH 'transition_exp' experiment '_' shock '.mat'];
    disp(['Loading: ' fname])
    load(fname,'ve')
    ve = ve(2);
end

fname = [PATH 'ValueFcn_exp' experiment '_' shock '.mat'];
disp(['Loading: ' fname])
load(fname,'D','V','wealth_grid','vgrid')   

Params.vgrid = vgrid;
npp = size(V,2);
ndstst = length(wealth_grid);

% interpolate vpar onto knotdistk
VonD = zeros(ndstst,npp);
for ip = 1:npp
    Vsp = vspline(V(:,ip));
    VonD(:,ip) = interp_vspline(Vsp,wealth_grid);
end



D = reshape(D,ndstst,npp);

end