
function tabData = tableLookup(V,D,wealthPcts)
%looks up percentiles in wealthPcts in D and reports corresponding V.
%do it for each ip in 1 to Params.npp
%result is matrix of dimension Params.npp by length(wealthPcts)


assert(all(size(V) == size(D)))

npp = size(V,2);

D = bsxfun(@rdivide,D,sum(D)); %normalize within each discrete type
D = cumsum(D);



tabData = zeros(npp,length(wealthPcts));
for iwealth = 1:length(wealthPcts)
    for ip = 1:npp
        wealth_ind = lookup(D(:,ip),wealthPcts(iwealth),3);
        tabData(ip,iwealth) = V(wealth_ind,ip);
    end
end


end