


function wa = weightedAverage(x,w,mask)
%takes average of x weighted by w over sub-matrix specified by mask, which
%should be logical of either dimension or 2D.

assert(all(size(x) == size(w)))

if ~exist('mask','var')
    wa = dot(x(:),w(:));
    return
end

%check if mask conforms to x
[n, m] = size(mask);
if n >1 && m>1
    assert(all(size(x) == size(mask)))
    mask_ind = 0;
elseif n == 1
    assert(m == size(x,2))
    mask_ind = 2;
elseif m == 1
    assert(n == size(x,1))
    mask_ind = 1;
else
    error('unrecognized shape of mask.  one dimension is probably zero')
end

if mask_ind == 0
    tmp_x = x(mask);
    tmp_w = w(mask);
elseif mask_ind == 1
    tmp_x = x(mask,:);
    tmp_w = w(mask,:);
else
    %mask_ind == 2
    tmp_x = x(:,mask);
    tmp_w = w(:,mask);
end

wa = dot(tmp_x(:),tmp_w(:))/sum(tmp_w(:));


end