function update = ZLB_hhld_update(Steady2Steady)

if ~exist('Steady2Steady','var')
    Steady2Steady = false;
end

load HhldEnv;
if Steady2Steady
    load D0;  %overwrites D loaded from HhldEnv.
end

load('transition_working.mat','ii','wage','ch','nh','taxpaidh','ppi','E','U','assetsh','InsuredUnemp');
load('transition_input.mat','laborMarketStatus','betashock','eulerwedge','laborwedge','avgTaxRate');  

laborwedge0 = laborwedge;
eulerwedge0 = eulerwedge;
avgTaxRate0 = avgTaxRate;
    
parPath = solveback(par,ppi(2:end),wage(2:end),1+ii,laborMarketStatus(2:end),betashock(2:end));
[Cpath, Npath, Bpath, taxpath,Uimp,NLFimp] = simulateforward(D,parPath,ppi(2:end),wage(2:end),1+ii,laborMarketStatus(2:end));

Tu = mean(Params.Tu(Params.estatus == 2));
To = mean(Params.To(Params.estatus == 3));

t = 2;
if ~isstruct(Params.incometax)
    assert(abs(Params.incometax * ( Npath(t)*wage(t+1) + ii(t)*Bpath(t-1)/ppi(t+1) + Params.nu * Tu * Uimp(t-1))  - taxpath(t)) < 1e-6)
end
assert(abs(-Bpath(t) - Cpath(t)*(1+Params.tauC) + Npath(t)*wage(t+1) + (1+ii(t))*Bpath(t-1)/ppi(t+1) + Params.nu * (Tu * Uimp(t-1) + To *NLFimp(t-1)) - taxpath(t))<1e-6)

assetsh_stst = Env.aggstst(strcmp(Params.aggnames,'assetsh'));

newlaborwedge = Params.psi1*(Npath./E(1:end-2)').^(Params.psi2)./ ((Cpath./Params.nu).^(-Params.sigma).*wage(2:end-1)');
neweulerwedge  = Cpath(1:end-1).^(-Params.sigma)./( (Bpath(1:end-1)/assetsh_stst).^(-0.004).*Params.betah .* betashock(2:end-2)' .*(1+ii(2:end-2)')./ppi(3:end-1)' .* Cpath(2:end).^(-Params.sigma)) ;
newavgTaxRate = taxpath./(Npath.*wage(2:end-1)'+ii(1:end-2)'.*[assetsh(1) Bpath(1:end-1)]./ppi(2:end-1)' + Tu * U(1:end-2)');    

%test = ch(2:end-2).^(-Params.sigma)./( (assetsh(2:end-2)/assetsh_stst).^(-0.004).*Params.betah .* betashock(2:end-2) .*(1+ii(2:end-2))./ppi(3:end-1) .* ch(3:end-1).^(-Params.sigma)) ;
%assert(all(abs(test-eulerwedge(2:end-2))<1e-6))
assert(all(abs(laborMarketStatus)<1e-10))
assert(all(abs(betashock-1)<1e-10))

subplot(3,3,1);
plot(ii(1:30)); title('ii')
subplot(3,3,2);
plot(ii(1:10)); title('ii')
subplot(3,3,3);
plot([nh(2:end-1) Npath']); title('nh')
subplot(3,3,4);
plot([ch(2:end-1) Cpath']); title('ch')
subplot(3,3,5);
plot([eulerwedge(2:end-2) neweulerwedge']); title('Euler wedge')
subplot(3,3,6);
plot([laborwedge(2:end-1) newlaborwedge']); title('labor wedge')
subplot(3,3,7);
plot([avgTaxRate(2:end-1) newavgTaxRate']); title('avg tax rate')
subplot(3,3,8);
plot([assetsh(2:end-1) Bpath']); title('assetsh')
subplot(3,3,9)
plot(InsuredUnemp(1:30)); title('Unemp')
drawnow;

RELAX = ones(248,1);
%RELAX(21:end) = 0.98.^([0:227]');  % I used this for ZLB
%RELAX(21:end) = 0.997.^([0:227]');  % I used this for other shocks
laborwedge(2:end-1) = (1-RELAX) .* laborwedge(2:end-1) + RELAX .* newlaborwedge';
eulerwedge(2:end-2) = (1-RELAX(1:end-1)) .* eulerwedge(2:end-2)+  RELAX(1:end-1) .* neweulerwedge';
avgTaxRate(2:end-1) =(1-RELAX) .* avgTaxRate(2:end-1)+ RELAX .* newavgTaxRate';


%Check if we have converged
test = @(orig,new)(max(abs(orig-new)./orig));
update = [test(laborwedge,laborwedge0) test(eulerwedge, eulerwedge0) test(avgTaxRate,avgTaxRate0)]
update = max(update);


save('HHldOutput.mat','laborwedge','eulerwedge','avgTaxRate');


%store value function
vgrid = Params.vgrid;
V = par2wide(parPath(:,1));
V = V(Params.par_vind,:);
wealth_grid = Params.knotDistrK;
save('ValueFcn.mat','D','V','vgrid','wealth_grid');

end



