


%----------------------------------------------------------------
% 0. Housekeeping (close all graphic windows)
%----------------------------------------------------------------

close all;

%----------------------------------------------------------------
% 1. Defining variables
%----------------------------------------------------------------

var Y
C
ce
N
ne
ppi    
B 
be
ii
G
E
U
NLF
taxpaide 
LumpSumTax
firmValue
revenue_from_corporate_inc_tax
transferspending
taxRevenue
S
margtaxe 
xe
div_cap
after_tax_div_intermed
dividend
pstar
pbarA
pbarB
netI
KL
wage
r
rhat
M
xehigh
xelow
Hrs
InsuredUnemp
ch
nh
assetsh
taxpaidh
ve
K;

varexo betashock laborMarketStatus z mpshock markupshock avgTaxRate laborwedge eulerwedge;


parameters sigma
rhoz
rhomp
rhomarkup
Tu
To
shockWeight_1
shockWeight_2
shockWeight_3
nu
transProbSS_EU
transProbSS_UU
transProbSS_NU
transProbZ_EU
transProbZ_UU
transProbZ_NU
transProbSS_EN
transProbSS_UN
transProbSS_NN
transProbZ_EN
transProbZ_UN
transProbZ_NN
alpha
delta
Psi
mu
theta
phiP
phiG
phiLST
upsilon
fixedCosts
tauC
tauP
tauK
betae
betah
skille
psi1
psi2
B_stst
G_stst
ii_stst
LumpSumTax_stst
assetsh_stst
margtax_3
margtax_2
margtax_1
margtax_0
cumultax_4
cumultax_3
cumultax_2
cumultax_1
cumultax_0
margtax_breakval
margtax_breakpoint;





%----------------------------------------------------------------
% 2. Calibration  see calibrate.m
%----------------------------------------------------------------
sigma = ##Params.sigma##;
rhoz = ##Params.rhoz##;
rhomp = ##Params.rhomp##;
rhomarkup = ##Params.rhomarkup##;
Tu  = ##mean(Params.Tu(Params.estatus == 2))##;
To = ##mean(Params.To(Params.estatus == 3))##;
shockWeight_1 = ##Params.shockWeight(1)##;
shockWeight_2 = ##Params.shockWeight(2)##;
shockWeight_3 = ##1-sum(Params.shockWeight)##;
nu = ##Params.nu##;
transProbSS_EU = ##invlogistic(max(Params.LFtransMat_ss(1,2),1e-10))##;
transProbSS_UU = ##invlogistic(max(Params.LFtransMat_ss(2,2),1e-10))##;
transProbSS_NU = ##invlogistic(max(Params.LFtransMat_ss(3,2),1e-10))##;
transProbZ_EU = ##Params.LFtransMat_z_nonLinear(1,2)##;
transProbZ_UU = ##Params.LFtransMat_z_nonLinear(2,2)##;
transProbZ_NU = ##Params.LFtransMat_z_nonLinear(3,2)##;
transProbSS_EN = ##invlogistic(max(Params.LFtransMat_ss(1,3),1e-10))##;
transProbSS_UN = ##invlogistic(max(Params.LFtransMat_ss(2,3),1e-10))##;
transProbSS_NN = ##invlogistic(max(Params.LFtransMat_ss(3,3),1e-10))##;
transProbZ_EN = ##Params.LFtransMat_z_nonLinear(1,3)##;
transProbZ_UN = ##Params.LFtransMat_z_nonLinear(2,3)##;
transProbZ_NN = ##Params.LFtransMat_z_nonLinear(3,3)##;
alpha = ##Params.alpha##;
delta = ##Params.delta##;
Psi = ##Params.Psi##;
mu = ##Params.mu##;
theta = ##Params.theta##;
phiP = ##Params.phiP##;
phiG = ##Params.phiG##;
phiLST = ##Params.phiLST##;
upsilon = ##Params.upsilon##;
fixedCosts = ##Params.fixedCost(1)##;
tauC = ##Params.tauC##;
tauP = ##Params.tauP##;
tauK = ##Params.tauK##;
betae = ##Params.betae##;
betah = ##Params.betah##;
skille = ##Params.skille##;
psi1 = ##Params.psi1##;
psi2 = ##Params.psi2##;
B_stst = ##Env.aggstst(strcmp(Params.aggnames,'B'))##;
G_stst = ##Env.aggstst(strcmp(Params.aggnames,'G'))##;
ii_stst= ##Env.aggstst(strcmp(Params.aggnames,'ii'))##;
LumpSumTax_stst = ##Env.aggstst(strcmp(Params.aggnames,'LumpSumTax'))##;
assetsh_stst = ##Env.aggstst(strcmp(Params.aggnames,'assetsh'))##;
margtax_3 = ##Params.incometax.marg(1)## ;
margtax_2 = ##Params.incometax.marg(2)## ;
margtax_1 = ##Params.incometax.marg(3)## ;
margtax_0 = ##Params.incometax.marg(4)## ;
margtax_breakval = ##Params.incometax.breakval## ;
margtax_breakpoint = ##Params.incometax.breakpoint## ;
cumultax_4 = ##Params.incometax.cumul(1)## ;
cumultax_3 = ##Params.incometax.cumul(2)## ;
cumultax_2 = ##Params.incometax.cumul(3)## ;
cumultax_1 = ##Params.incometax.cumul(4)## ;
cumultax_0 = ##Params.incometax.cumul(5)## ;


%----------------------------------------------------------------
% 3. Model
%----------------------------------------------------------------

model;
//log(z)-rhoz*log(z(-1))-epsz;  
//-mpshock + rhomp * mpshock(-1) + epsmp;
//-markupshock + rhomarkup * markupshock(-1) + epsmkup;
be + assetsh - B; 
-B  + B(-1)*(1 + ii(-1))/ppi + G + transferspending - taxRevenue; 
KL - K(-1)/N;  
Y*S - z * K(-1)^alpha * N^(1-alpha);
N = nh + ne*skille;  
psi1*ne^(psi2) - ce^(-sigma)*skille*wage*(1-margtaxe)/(1+tauC);
Hrs - ne - nh; 
xe = be(-1)/ppi*ii(-1) + skille*ne*wage + dividend;
xelow = min(xe,margtax_breakpoint);
xehigh = max(xe-margtax_breakpoint,0);
ce + ch - C;
ve = log(ce) - psi1*ne^(1 + psi2)/(1+psi2) + betae * ve(+1);
div_cap =  r *K(-1) - K + K(-1) - Psi/2 * ((K-K(-1))/K(-1))^2 * K(-1);
(K + C + G) - (Y + (1-delta)*K(-1) - fixedCosts -  Psi/2 * ((K-K(-1))/K(-1))^2 * K(-1));  
ii = ii_stst + phiP*(ppi-1) + mpshock;
-ppi + ((1-theta)/(1-theta*pstar^(1/(1-mu))))^(1-mu);  
 -pstar + pbarA/pbarB;
-S + (1-theta)*S(-1)*ppi^(-mu/(1-mu)) + theta*pstar^(mu/(1-mu));  
-log(G) + log(G_stst) + (-phiG/phiLST) * (LumpSumTax - LumpSumTax_stst);
LumpSumTax - log((B_stst/B(-1))^phiLST) - LumpSumTax_stst;
 -betae * betashock * ce(+1)^(-sigma) / ce^(-sigma)*(1 + ii *(1-margtaxe(+1)))/ppi(+1) + 1; 
-(1-margtaxe(+1))/(1-margtaxe)*betae * betashock * ce(+1)^(-sigma) / ce^(-sigma)/(1+tauP)*(1 + r(+1)  - (Psi/2)*(netI(+1)/K)^2 + Psi*(netI(+1)/K)*(K(+1)/K)) + (1+Psi*(netI/K(-1))); 
netI = K-K(-1);
-firmValue*(1 + tauP) + div_cap + (1-margtaxe(+1))/(1-margtaxe)*betae * betashock * ce(+1)^(-sigma) / ce^(-sigma) * firmValue(+1);
-pbarB + Y + (1-margtaxe(+1))/(1-margtaxe)*betae * betashock * ce(+1)^(-sigma) / ce^(-sigma)*(1-theta)*ppi(+1)^(-mu/(1-mu)-1)*pbarB(+1);
pbarA = M*mu*Y  +(1-margtaxe(+1))/(1-margtaxe)*betae * betashock * ce(+1)^(-sigma) / ce^(-sigma)*(1-theta)*ppi(+1)^(-mu/(1-mu))*pbarA(+1) + markupshock; 
wage =  M*(1-alpha)*z* KL^alpha;
rhat =  -delta + M*alpha*z* KL^(alpha-1);
r = (1-tauK)/(1-tauK*upsilon) * rhat;
after_tax_div_intermed = (1-tauK)*(Y - M * z * K(-1)^alpha * N^(1-alpha) - fixedCosts);
revenue_from_corporate_inc_tax = tauK*(Y - M * z * K(-1)^alpha * N^(1-alpha) - fixedCosts) + tauK*(1-upsilon)/(1-upsilon*tauK)*rhat*K(-1);
dividend =  after_tax_div_intermed + div_cap - tauP*firmValue;
taxpaide = cumultax_4 * xelow^4 + cumultax_3 * xelow^3 + cumultax_2 * xelow^2 + cumultax_1 * xelow + cumultax_0+margtax_breakval * xehigh; 
margtaxe = margtax_3 * xelow^3 + margtax_2 * xelow^2 + margtax_1 * xelow + margtax_0; 
//laborMarketStatus = shockWeight_1 * log(z) - shockWeight_2 * mpshock - shockWeight_3 * markupshock;
transferspending = Tu * U + To*NLF;
taxRevenue = taxpaidh + taxpaide + LumpSumTax  + tauC*C + firmValue*tauP + revenue_from_corporate_inc_tax;

E = nu - NLF - U;
U = 1/(1+exp(-(transProbSS_EU + transProbZ_EU * laborMarketStatus))) * E(-1)
   +1/(1+exp(-(transProbSS_UU + transProbZ_UU * laborMarketStatus))) * U(-1)
    +1/(1+exp(-(transProbSS_NU + transProbZ_NU * laborMarketStatus))) * NLF(-1);

NLF = 1/(1+exp(-(transProbSS_EN + transProbZ_EN * laborMarketStatus))) * E(-1)
   +1/(1+exp(-(transProbSS_UN + transProbZ_UN * laborMarketStatus))) * U(-1)
    +1/(1+exp(-(transProbSS_NN + transProbZ_NN * laborMarketStatus))) * NLF(-1);

InsuredUnemp = U/E;

//These are auxiliary equations: that represent the impatient household behavior
(1+tauC)*ch + assetsh =  (1+ ii(-1))*assetsh(-1)/ppi + nh*wage + transferspending - taxpaidh;
psi1*(nh/E(-1))^(psi2) = (ch/nu)^(-sigma)*wage * laborwedge;
ch^(-sigma) = (assetsh/assetsh_stst)^(-0.004) * eulerwedge * betah * betashock *(1+ii)/ppi(+1) * ch(+1)^(-sigma);
taxpaidh = avgTaxRate * (nh*wage+ii(-1)*assetsh(-1)/ppi + Tu * U(-1));

end;

%----------------------------------------------------------------
% 4. Computation
%----------------------------------------------------------------

initval;
assetsh = ##Env.aggstst(strcmp(Params.aggnames,'assetsh'))##;
ch = ##ch##;
taxpaidh = ##taxpaidh##;
nh = ##Env.aggstst(strcmp(Params.aggnames,'nh'))##;
z = ##Env.aggstst(strcmp(Params.aggnames,'z'))##;
mpshock = ##Env.aggstst(strcmp(Params.aggnames,'mpshock'))##;
markupshock  = ##Env.aggstst(strcmp(Params.aggnames,'markupshock'))##;
B  = ##Env.aggstst(strcmp(Params.aggnames,'B'))##;
ppi = ##Env.aggstst(strcmp(Params.aggnames,'ppi'))##;
ii = ##Env.aggstst(strcmp(Params.aggnames,'ii'))##;
G = ##Env.aggstst(strcmp(Params.aggnames,'G'))##;
U = ##Params.nu*Env.aggstst(strcmp(Params.aggnames,'U'))##;
NLF = ##Params.nu*Env.aggstst(strcmp(Params.aggnames,'NLF'))##;
E = nu - U - NLF;
LumpSumTax = ##Env.aggstst(strcmp(Params.aggnames,'LumpSumTax'))##;
firmValue = ##Env.aggstst(strcmp(Params.aggnames,'firmValue'))##;
C = ##Env.aggstst(strcmp(Params.aggnames,'C'))##;
laborMarketStatus = 0;
Y = ##Env.aggstst(strcmp(Params.aggnames,'Y'))##;
S = ##Env.aggstst(strcmp(Params.aggnames,'S'))##;
K = ##Env.aggstst(strcmp(Params.aggnames,'K'))##;
N = ##Env.aggstst(strcmp(Params.aggnames,'N'))##;
ce = ##Env.aggstst(strcmp(Params.aggnames,'ce_track'))##;
ne = ##Env.aggstst(strcmp(Params.aggnames,'ne'))##;
be = ##Env.aggstst(strcmp(Params.aggnames,'be'))##;
xe = ##Env.aggstst(strcmp(Params.aggnames,'xe'))##;
xelow = xe;
xehigh = 0;
taxpaide  = cumultax_4 * xe^4 + cumultax_3 * xe^3 + cumultax_2 * xe^2 + cumultax_1 * xe + cumultax_0;
margtaxe  = margtax_3 * xe^3 + margtax_2 * xe^2 + margtax_1 * xe + margtax_0 ;
div_cap = ##Env.aggstst(strcmp(Params.aggnames,'div_cap'))##;
pstar = ##Env.aggstst(strcmp(Params.aggnames,'pstar'))##;
pbarA = ##Env.aggstst(strcmp(Params.aggnames,'pbarA'))##;
pbarB = ##Env.aggstst(strcmp(Params.aggnames,'pbarB'))##;
netI = 0;
KL = ##Env.aggstst(strcmp(Params.aggnames,'KL'))##;
M = ##Env.aggstst(strcmp(Params.aggnames,'M'))##;
wage = M*(1-alpha)*z* KL^alpha;
rhat = -delta + M*alpha*z* KL^(alpha-1);
r = (1-tauK)/(1-tauK*upsilon) * rhat;
revenue_from_corporate_inc_tax = tauK*(Y - M * z * K^alpha * N^(1-alpha) - fixedCosts) + tauK*(1-upsilon)/(1-upsilon*tauK)*rhat*K;
after_tax_div_intermed = (1-tauK)*(Y - M * z * K^alpha * N^(1-alpha) - fixedCosts);
dividend = after_tax_div_intermed + div_cap - tauP*firmValue;
Hrs = ##Env.aggstst(strcmp(Params.aggnames,'Hrs'))##;
transferspending = Tu * U + To*NLF;
taxRevenue = taxpaidh + taxpaide + LumpSumTax  + tauC*C + firmValue*tauP + revenue_from_corporate_inc_tax;
betashock = 1;
InsuredUnemp = U/E;
laborwedge = psi1*(nh/E)^(psi2)/((ch/nu)^(-sigma)*wage );
eulerwedge =  1/(betah * betashock *(1+ii)/ppi) ;
avgTaxRate = taxpaidh/ (nh*wage+ii*assetsh/ppi + Tu * U);
ve = (log(ce) - psi1*ne^(1 + psi2)/(1+psi2))/(1-betae);
end;


steady;
check;



EXPERIMENT = '0';
shock_names = {'z','mp', 'markup'};

for ishock = 1:3

    copyfile('orig_transition_input.mat','transition_input.mat')
    copyfile(['Exog_' shock_names{ishock} '.mat'], 'Exog.mat')

    relstep = 0.2;
    for relax = 1:100

        rudist = relaxUpdate(relstep);

        disp(['Experiment: ' EXPERIMENT '   Shock: ' shock_names{ishock} '  Iteration: ' num2str(relax) '   ExogDistance: ' num2str(rudist)])

        initval_file(filename = transition_input);

        simul(periods=248);
        dynasave(transition_working);
        copyfile('transition_working','transition_working.mat')

        update = transition_hhld_update;
        combineMatFiles('transition_working.mat','HHldOutput.mat','transition_input.mat');

        if rudist < 1e-10 && update < 5e-4
            break;
        end

        if rudist < 0.2 || update < 5e-4
            relstep = 1;
        end

    end

    copyfile('transition_input.mat',['transition_exp' EXPERIMENT '_' shock_names{ishock} '.mat'])
    copyfile('ValueFcn.mat', ['ValueFcn_exp' EXPERIMENT '_' shock_names{ishock} '.mat'])
end



%store value function for no shock
load('HhldEnv.mat','par','D','Params')
vgrid = Params.vgrid;
V = par2wide(par);
V = V(Params.par_vind,:);
wealth_grid = Params.knotDistrK;
save(['ValueFcn_exp' EXPERIMENT '_noshock.mat'],'D','V','vgrid','wealth_grid');






