function writeModFile(fname_in,fname_out,Env,par,D,NUMBER_OF_DIGITS)

global Params;

%check not to over-write the input file:
assert(~strcmp(fname_in,fname_out))


%prepare some of the data
ii = Env.aggstst(strcmp(Params.aggnames,'ii'));
M = Env.aggstst(strcmp(Params.aggnames,'M'));
KL = Env.aggstst(strcmp(Params.aggnames,'KL'));
z = Env.aggstst(strcmp(Params.aggnames,'z'));
nh = Env.aggstst(strcmp(Params.aggnames,'nh'));
wage =  M*(1-Params.alpha)*z* KL.^Params.alpha;
[ch, ~, taxpaidh] = expect_C(D,par,1+ii,wage);
ch = ch*Params.nu;
taxpaidh = taxpaidh*Params.nu;
laborwedge = Params.psi1*nh^(Params.psi2)/(ch^(-Params.sigma)*wage);
eulerwedge  = 1/(Params.betah *(1+ii));

%check names don't clash
assert(~exist('A','var'))
assert(~exist('fileread_info','var'))
assert(~exist('Aout','var'))
assert(~exist('sx','var'))
assert(~exist('x_wrMod','var'))
assert(~exist('i','var'))
assert(~exist('fid','var'))



%Read in the mod file
A = fileread(fname_in);
fileread_info = regexp(A, '##');


numformat = ['%0.' num2str(NUMBER_OF_DIGITS) 'f'];

% replace data with updated values
Aout = A(1:fileread_info(1)-1);
try
    i = 0;
    while i < length(fileread_info)
        sx = A(fileread_info(i+1)+2:fileread_info(i+2)-1);
        eval(['x_wrMod = ' sx ';']);

        sx = num2str(x_wrMod,numformat);
        Aout = [Aout sx];

        %increment i and add intervening text to Aout
        if i+3 <= length(fileread_info)
            Aout = [Aout A(fileread_info(i+2)+2:fileread_info(i+3)-1)];
        else
            Aout = [Aout A(fileread_info(end)+2:end)];
        end
        i = i + 2;
    
    end
    
catch
    disp(Aout)
    error('Error in writeModFile')
end




% write the file
disp(fname_out);
fid = fopen(fname_out,'w');
fprintf(fid,'%s', Aout);
fclose(fid);
