** Program that generates low-frequency trend using Muller Watson

*`1' is the series
*`2' is the q (number of cosine functions) "dyn" for dynamic
*`3' is quarterly indicator "q" for quarterly
*`4' is the time variable
*`5' is the id (if panel data)


program define trends_mw10 
	quietly {
	* For the cases where it is panel data versus just time series
	if missing(`5') {
		gen x = 1
		local id = 1
		sort `4'
	}
	else {
		egen x = group(`5')
		sum x
		local id = r(max)
		sort `5' `4'
	}
	
	* Variable that stores the predicted values
	gen MWT_`1' = .
	
	* Do the iteration for each id
	forvalues i = 1 / `id' {
		
		* Count number of observation 
		egen count_obs = count(`1') if x == `i', by(x)
		sum count_obs
		local obs = r(max)
		
		if `obs' < 15 { // if there is less than 15 obs keep the original series
			drop count_obs
			replace MWT_`1' = `1' if  x == `i'
			continue
		}
		else { // else proceed
			* Gen dynamic q if q is not given fixed
			if "`2'" == "dyn" {
				if "`3'" == "q" {
					scalar q = (floor((`obs'/4) / 5))
				}
				else {
					scalar q = floor(`obs' / 5)
				}
				
			}
			else {
				scalar q = `2'
			}
			
			* Gen t=1,2,...,T and T
			gen csum = sum(`1') if x == `i'
			replace csum = 1 if csum > 0 & x == `i'
			replace csum = . if csum == 0
			egen t = group(`4' csum) if x == `i'
			replace t = . if `1' == .
			sum t
			local T = r(max)
			
			* Generate cosine functions - 1 per each q
			forvalues j = 1 / `=scalar(q)' {
				gen cosine_`j' = cos(`j' * ((t-(1/2))/(`T')) * _pi) if x == `i'
			}
			
			* Regression and prediction
			reg `1' cosine_* 
			predict double MWT_`1'_`i' if  x == `i' & `1' != ., xb
			replace MWT_`1' = MWT_`1'_`i' if  x == `i'
			
			drop t cosine_* MWT_`1'_`i' count_obs csum
		}
	}
	drop x
	}
end 




program define trends_mw5


	quietly {
	* For the cases where it is panel data versus just time series
	if missing(`5') {
		gen x = 1
		local id = 1
		sort `4'
	}
	else {
		egen x = group(`5')
		sum x
		local id = r(max)
		sort `5' `4'
	}
	
	* Variable that stores the predicted values
	gen MWF_`1' = .
	
	* Do the iteration for each id
	forvalues i = 1 / `id' {
		
		* Count number of observation 
		egen count_obs = count(`1') if x == `i', by(x)
		sum count_obs
		local obs = r(max)
		
		if `obs' < 15 { // if there is less than 15 obs keep the original series
			drop count_obs
			replace MWF_`1' = `1' if  x == `i'
			continue
		}
		else { // else proceed
			* Gen dynamic q if q is not given fixed
			if "`2'" == "dyn" {
				if "`3'" == "q" {
					scalar q = (floor((`obs'/4) / 2.5))
				}
				else {
					scalar q = floor(`obs' / 2.5)
				}
				
			}
			else {
				scalar q = `2'
			}
			
			* Gen t=1,2,...,T and T
			gen csum = sum(`1') if x == `i'
			replace csum = 1 if csum > 0 & x == `i'
			replace csum = . if csum == 0
			egen t = group(`4' csum) if x == `i'
			replace t = . if `1' == .
			sum t
			local T = r(max)
			
			* Generate cosine functions - 1 per each q
			forvalues j = 1 / `=scalar(q)' {
				gen cosine_`j' = cos(`j' * ((t-(1/2))/(`T')) * _pi) if x == `i'
			}
			
			* Regression and prediction
			reg `1' cosine_* 
			predict double MWF_`1'_`i' if  x == `i' & `1' != ., xb
			replace MWF_`1' = MWF_`1'_`i' if  x == `i'
			
			drop t cosine_* MWF_`1'_`i' count_obs csum
		}
	}
	drop x
	}
end 


program define trends_mw3
	quietly {
	* For the cases where it is panel data versus just time series
	if missing(`5') {
		gen x = 1
		local id = 1
		sort `4'
	}
	else {
		egen x = group(`5')
		sum x
		local id = r(max)
		sort `5' `4'
	}
	
	* Variable that stores the predicted values
	gen MWH_`1' = .
	
	* Do the iteration for each id
	forvalues i = 1 / `id' {
		
		* Count number of observation 
		egen count_obs = count(`1') if x == `i', by(x)
		sum count_obs
		local obs = r(max)
		
		if `obs' < 15 { // if there is less than 15 obs keep the original series
			drop count_obs
			replace MWH_`1' = `1' if  x == `i'
			continue
		}
		else { // else proceed
			* Gen dynamic q if q is not given fixed
			if "`2'" == "dyn" {
				if "`3'" == "q" {
					scalar q = (floor((`obs'/4) / 1.5))
				}
				else {
					scalar q = floor(`obs' / 1.5)
				}
				
			}
			else {
				scalar q = `2'
			}
			
			* Gen t=1,2,...,T and T
			gen csum = sum(`1') if x == `i'
			replace csum = 1 if csum > 0 & x == `i'
			replace csum = . if csum == 0
			egen t = group(`4' csum) if x == `i'
			replace t = . if `1' == .
			sum t
			local T = r(max)
			
			* Generate cosine functions - 1 per each q
			forvalues j = 1 / `=scalar(q)' {
				gen cosine_`j' = cos(`j' * ((t-(1/2))/(`T')) * _pi) if x == `i'
			}
			
			* Regression and prediction
			reg `1' cosine_* 
			predict double MWH_`1'_`i' if  x == `i' & `1' != ., xb
			replace MWH_`1' = MWH_`1'_`i' if  x == `i'
			
			drop t cosine_* MWH_`1'_`i' count_obs csum
		}
	}
	drop x
	}
end 




program define trends_mw7
	quietly {
	* For the cases where it is panel data versus just time series
	if missing(`5') {
		gen x = 1
		local id = 1
		sort `4'
	}
	else {
		egen x = group(`5')
		sum x
		local id = r(max)
		sort `5' `4'
	}
	
	* Variable that stores the predicted values
	gen MWS_`1' = .
	
	* Do the iteration for each id
	forvalues i = 1 / `id' {
		
		* Count number of observation 
		egen count_obs = count(`1') if x == `i', by(x)
		sum count_obs
		local obs = r(max)
		
		if `obs' < 15 { // if there is less than 15 obs keep the original series
			drop count_obs
			replace MWS_`1' = `1' if  x == `i'
			continue
		}
		else { // else proceed
			* Gen dynamic q if q is not given fixed
			if "`2'" == "dyn" {
				if "`3'" == "q" {
					scalar q = (floor((`obs'/4) / 3.5))
				}
				else {
					scalar q = floor(`obs' / 3.5)
				}
				
			}
			else {
				scalar q = `2'
			}
			
			* Gen t=1,2,...,T and T
			gen csum = sum(`1') if x == `i'
			replace csum = 1 if csum > 0 & x == `i'
			replace csum = . if csum == 0
			egen t = group(`4' csum) if x == `i'
			replace t = . if `1' == .
			sum t
			local T = r(max)
			
			* Generate cosine functions - 1 per each q
			forvalues j = 1 / `=scalar(q)' {
				gen cosine_`j' = cos(`j' * ((t-(1/2))/(`T')) * _pi) if x == `i'
			}
			
			* Regression and prediction
			reg `1' cosine_* 
			predict double MWS_`1'_`i' if  x == `i' & `1' != ., xb
			replace MWS_`1' = MWS_`1'_`i' if  x == `i'
			
			drop t cosine_* MWS_`1'_`i' count_obs csum
		}
	}
	drop x
	}
end 




program define trends_mw15
	quietly {
	* For the cases where it is panel data versus just time series
	if missing(`5') {
		gen x = 1
		local id = 1
		sort `4'
	}
	else {
		egen x = group(`5')
		sum x
		local id = r(max)
		sort `5' `4'
	}
	
	* Variable that stores the predicted values
	gen MWFIF_`1' = .
	
	* Do the iteration for each id
	forvalues i = 1 / `id' {
		
		* Count number of observation 
		egen count_obs = count(`1') if x == `i', by(x)
		sum count_obs
		local obs = r(max)
		
		if `obs' < 15 { // if there is less than 15 obs keep the original series
			drop count_obs
			replace  MWFIF_`1' = `1' if  x == `i'
			continue
		}
		else { // else proceed
			* Gen dynamic q if q is not given fixed
			if "`2'" == "dyn" {
				if "`3'" == "q" {
					scalar q = (floor((`obs'/4) / 7.5))
				}
				else {
					scalar q = floor(`obs' / 7.5)
				}
				
			}
			else {
				scalar q = `2'
			}
			
			* Gen t=1,2,...,T and T
			gen csum = sum(`1') if x == `i'
			replace csum = 1 if csum > 0 & x == `i'
			replace csum = . if csum == 0
			egen t = group(`4' csum) if x == `i'
			replace t = . if `1' == .
			sum t
			local T = r(max)
			
			* Generate cosine functions - 1 per each q
			forvalues j = 1 / `=scalar(q)' {
				gen cosine_`j' = cos(`j' * ((t-(1/2))/(`T')) * _pi) if x == `i'
			}
			
			* Regression and prediction
			reg `1' cosine_* 
			predict double  MWFIF_`1'_`i' if  x == `i' & `1' != ., xb
			replace  MWFIF_`1' =  MWFIF_`1'_`i' if  x == `i'
			
			drop t cosine_*  MWFIF_`1'_`i' count_obs csum
		}
	}
	drop x
	}
end 




program define trends_mw20
	quietly {
	* For the cases where it is panel data versus just time series
	if missing(`5') {
		gen x = 1
		local id = 1
		sort `4'
	}
	else {
		egen x = group(`5')
		sum x
		local id = r(max)
		sort `5' `4'
	}
	
	* Variable that stores the predicted values
	gen MWTW_`1' = .
	
	* Do the iteration for each id
	forvalues i = 1 / `id' {
		
		* Count number of observation 
		egen count_obs = count(`1') if x == `i', by(x)
		sum count_obs
		local obs = r(max)
		
		if `obs' < 15 { // if there is less than 15 obs keep the original series
			drop count_obs
			replace MWTW_`1' = `1' if  x == `i'
			continue
		}
		else { // else proceed
			* Gen dynamic q if q is not given fixed
			if "`2'" == "dyn" {
				if "`3'" == "q" {
					scalar q = (floor((`obs'/4) / 10))
				}
				else {
					scalar q = floor(`obs' / 10)
				}
				
			}
			else {
				scalar q = `2'
			}
			
			* Gen t=1,2,...,T and T
			gen csum = sum(`1') if x == `i'
			replace csum = 1 if csum > 0 & x == `i'
			replace csum = . if csum == 0
			egen t = group(`4' csum) if x == `i'
			replace t = . if `1' == .
			sum t
			local T = r(max)
			
			* Generate cosine functions - 1 per each q
			forvalues j = 1 / `=scalar(q)' {
				gen cosine_`j' = cos(`j' * ((t-(1/2))/(`T')) * _pi) if x == `i'
			}
			
			* Regression and prediction
			reg `1' cosine_* 
			predict double MWTW_`1'_`i' if  x == `i' & `1' != ., xb
			replace MWTW_`1' = MWTW_`1'_`i' if  x == `i'
			
			drop t cosine_* MWTW_`1'_`i' count_obs csum
		}
	}
	drop x
	}
end 
