********************************************************************************
* Replication package for: "The Four R-stars: From Interest Rates to Inflation and Back"
*     Anna Pilipentseva, Nicholas Tokay, and Ricardo Reis 
*     2025
*
*     Plotting figure 1, US baseline results
********************************************************************************

clear all

*---------------------------------------------------------------*
* Define file paths (adjust these paths as needed)
*---------------------------------------------------------------*
*local basePath    "/Users/pilipentseva/Dropbox/Ricardo/RA-MarinaSeyed/Chile-rstar/Replication_Package"
local basePath   "/Users/r.a.reis/Dropbox/05Shared_folders/RA-CFMpredoc/Chile-rstar/Replication_Package"  // 
local interDataPath "./Data/Intermediate Data"

cd "`basePath'"

********************************************************************************
* Set options for plotting and detrending
********************************************************************************
	
* Plot scheme
set scheme cleanplots
	* Colors
	global c1 green
	global c2 sand*0.8

*Detrending program
do Code/0_Aux_programs/trends.do
	* Detrend using Muller Watsonm 10pyear trend)
	global trend MWT

********************************************************************************
* Calculating US private m, y, rho, and i
********************************************************************************

* Annual updated data
use "`interDataPath'/ampf_main_us.dta",clear
sort year

* Generate variables of interest: m
gen m_nom = NOS_priv_NS/Kpriv_n_NS*100
gen m1 = m_nom - spf10_mean 		 
gen wacc_baa = (((e/v) *(m_nom)) + ((d/v)*baa*(1-eff_tax_rate))) - spf10_mean

* Generate variables of interest: y
gen y_nom = govbond		// nominal yield
gen y1 = y_nom - spf10_mean			
gen y2 = dfii10 		// TIPS, already inflation indexed, so no need for inflation substraction				

* Generate variables of interest: rho
gen rho1 = dgs1[_n - 1] - cpi	// Adjustment for inflation is made with CPI
gen rho10 = 100*((1 + dgs10[_n - 1]/100)^10 / (1 + dgs10/100)^9 - 1) - cpi

* Generate variables of interest: i
gen i1 = effr - inflation_target	 // effective Fed funds minus target
gen i2 = tb_3m - inflation_target		//// 3-month tbill minus traget


********************************************************************************
*Detrending and choosing sample
********************************************************************************

* Start and end
global year = 1995

*Adjust data so that calculate trend using only the data that will be in the plot
drop if year < 1995
drop if year > 2019

* Trends
local detrend m1 wacc_baa y1 y2 rho1 rho10 i1 i2 
foreach i of varlist `detrend' {
	trends_mw10 `i' "dyn" "y" year 
}

********************************************************************************
* Ploting
********************************************************************************
tsset year


* Figurea 1a) m realised and expected
twoway tsline m1 ${trend}_m1 wacc_baa ${trend}_wacc_baa if  year >= 1995 & year<=2019, ///
		legend(label(1 "Expected return") label(2 "(trend)") label(3 "Leveraged return") label(4 "(trend)") row(1) size(*1) pos(6)) ///
		color($c1 $c1 $c2 $c2 ) ///
		lp(solid solid dash dash) ///
		lw(thin thick thin thick) ///
		ytitle("Percentage") xtitle("") ///
		tlabel(1995(5)2020) ///
		ylabel(0(2)12) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_us_m_9519.pdf", as(pdf) replace

		
* Figure 1b) y, expected from surveys and TIPS
twoway tsline y1 ${trend}_y1 y2 ${trend}_y2 if year >= 1995 & year<=2019, ///
		legend(label(1 "Survey expectations") label(2 "(trend)") label(3 "Market expectations") label(4 "(trend)") row(1) size(*1) pos(6)) ///
		color($c1 $c1 $c2 $c2 ) ///
		lp(solid solid dash dash) ///
		lw(thin thick thin thick) ///
		ytitle("Percentage") xtitle("") ///
		tlabel(1995(5)2020) ///
		ylabel(0(2)12) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_us_y_9519.pdf", as(pdf) replace

		
* Figure 1c) rho, using 10-year hpr or simple realised yield on 1-year
twoway tsline rho10 ${trend}_rho10 rho1 ${trend}_rho1 if year >= 1995 & year<=2019, ///	
		legend(label(1 "10-year") label(2 "(trend)") label(3 "1-year") label(4	 "(trend)") row(1) size(*1) pos(6)) ///
		color($c1 $c1 $c2 $c2 ) ///
		lp(solid solid dash dash) ///
		lw(thin thick thin thick) ///
		ytitle("Percentage") xtitle("") ///
		tlabel(1995(5)2020) ///
		ylabel(-5(2)15) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_us_rho_9519.pdf", as(pdf) replace


* Figure 1c)  i, using both EFFR and Tbill
twoway tsline i1 ${trend}_i1 i2 ${trend}_i2 if  year >= 1995  & year<=2019, ///
		legend(label(1 "Fed Funds minus target") label(2 "(trend)") label(3 "T-bill minus target") label(4 "(trend)") row(1) size(*1) pos(6)) ///
		color($c1 $c1 $c2 $c2 ) ///
		lp(solid solid dash dash) ///
		lw(thin thick thin thick) ///
		ytitle("Percentage") xtitle("") ///
		tlabel(1995(5)2020) ///
		ylabel(-4(2)8) ///
		ylabel(-4(2)8) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_us_i_9519.pdf", as(pdf) replace





		

