********************************************************************************
* Replication package for: "The Four R-stars: From Interest Rates to Inflation and Back"
*     Anna Pilipentseva, Nicholas Tokay, and Ricardo Reis 
*     2025
*
*     Plotting figure 5, US recent data
********************************************************************************

clear all

*---------------------------------------------------------------*
* Define file paths (adjust these paths as needed)
*---------------------------------------------------------------*
*local basePath    "/Users/pilipentseva/Dropbox/Ricardo/RA-MarinaSeyed/Chile-rstar/Replication_Package"
local basePath   "/Users/r.a.reis/Dropbox/05Shared_folders/RA-CFMpredoc/Chile-rstar/Replication_Package"  // 
local interDataPath "./Data/Intermediate Data"

cd "`basePath'"

********************************************************************************
* Set options for plotting and detrending
********************************************************************************
	
* Plot scheme
set scheme cleanplots
	* Colors
	global c1 green
	global c2 sand*0.8
	global c3 eltblue*1.2
	global c4 red*1.2

*Detrending program
do Code/0_Aux_programs/trends.do
	* Detrend using Muller Watsonm 10pyear trend)
	global trend MWT

********************************************************************************
* Calculating US private m, y, rho, and i, quarterl since 2021
********************************************************************************


* --- Start with NOS ---
use "`interDataPath'/us_quarterly_working.dta", clear
sort date
tsset date, quarterly

* --- For K read annual values and divide by 4 ---
/*
// Load the dataset
use "./Data/Intermediate Data/ampf_main_us.dta", clear
	// Extract values for 2021
	gen Kpriv_n_NS_2021 = .
	replace Kpriv_n_NS_2021 = Kpriv_n_NS if year == 2021
	// Extract values for 2022
	gen Kpriv_n_NS_2022 = .
	replace Kpriv_n_NS_2022 = Kpriv_n_NS if year == 2022
	// Extract values for 2023
	gen Kpriv_n_NS_2023 = .
	replace Kpriv_n_NS_2023 = Kpriv_n_NS if year == 2023
	// Keep only the extracted values
	keep Kpriv_n_NS_2021 Kpriv_n_NS_2022 Kpriv_n_NS_2023

	// Drop any missing values to keep the dataset clean
	drop if missing(Kpriv_n_NS_2021) & missing(Kpriv_n_NS_2022) & missing(Kpriv_n_NS_2023)
	// Display the extracted values in the results window
	list
	// Results which I got
	*Kpriv_n_NS_2021 = 59313 
	*Kpriv_n_NS_2022 = 66405.1         
	*Kpriv_n_NS_2023 = 68096.2 |
*/	 
gen Kpriv_n_NS = .
replace Kpriv_n_NS = 59313 if year == 2021
replace Kpriv_n_NS = 66405.1 if year == 2022
replace Kpriv_n_NS = 68096.2 if year == 2023

*And so here is m
gen m = NOS_priv_dean /Kpriv_n_NS*100 - spf10_mean 

*Here is y, form TIPS 
gen y = dfii10 

*Here is rho, from 10-year yield
gen rho = 100 * ( (1 + L4.dgs10 / 100)^10 / (1 + dgs10 / 100)^9 - 1 ) - cpi_annualized
	// Since dgs10 is already annaulized, use number of years directly as 10 and 9 instead of 40 and 36
	// Adjustment for inflation is made with CPI

* Here is policy rate from FFR
gen i = effr - inflation_target


********************************************************************************
* Choosing sample
********************************************************************************

drop if year < 2021


********************************************************************************
* Ploting
********************************************************************************
tsset qdate
		
* Figurea 5) Recent data
twoway connected m y rho i qdate, ///
		legend(label(1 "m ") label(2 "y") label(3 "rho") label(4 "i") row(1) size(*1) pos(6)) ///
		color($c1 $c2 $c3 $c4 ) ///
		lp(solid solid solid solid) ///
		msize(large large large large) ///
		lw(thin thin thin thin) ///
		ytitle("Percentage") xtitle("Quarter") title("The 4 r-stars after the pandemic") ///
		ylabel(-20(2)20) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_us_quarterly_latest.pdf", as(pdf) replace

twoway connected m y i qdate, ///
		legend(label(1 "m ") label(2 "y") label(3 "i") row(3) size(*1) pos(2)) ///
		color($c1 $c2 $c3 ) ///
		lp(solid solid solid ) ///
		msize(large large large) ///
		lw(thick thick thick) ///
		ytitle("Percentage") xtitle("") ///
		ylabel(-4(1)10) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_us_quarterly_latest_left.pdf", as(pdf) replace

twoway connected rho qdate, ///
		legend(label(1 "rho") row(1) size(*1) pos(6)) ///
		color($c4 ) ///
		lp(solid) ///
		msize(large) ///
		lw(thick ) ///
		ytitle("Percentage") xtitle("") ///
		ylabel(-32(4)24) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_us_quarterly_latest_right.pdf", as(pdf) replace




	 