********************************************************************************
* Replication package for: "The Four R-stars: From Interest Rates to Inflation and Back"
*     Anna Pilipentseva, Nicholas Tokay, and Ricardo Reis 
*     2025
*
*     Plotting figure appendix, US and UK historical values
********************************************************************************

clear all

*---------------------------------------------------------------*
* Define file paths (adjust these paths as needed)
*---------------------------------------------------------------*
*local basePath    "/Users/pilipentseva/Dropbox/Ricardo/RA-MarinaSeyed/Chile-rstar/Replication_Package"
local basePath   "/Users/r.a.reis/Dropbox/05Shared_folders/RA-CFMpredoc/Chile-rstar/Replication_Package"  // 
local interDataPath "./Data/Intermediate Data"

cd "`basePath'"

********************************************************************************
* Set options for plotting and detrending
********************************************************************************
	
* Plot scheme
set scheme cleanplots
	* Colors
	global c1 green
	global c2 sand*0.8
	global c3 eltblue*1.2

*Detrending program
do Code/0_Aux_programs/trends.do
	* Detrend using Muller Watson 20-year trend)
	global trend MWTW

********************************************************************************
* UK data: focus on non-dweillings. Total, since no private series.
********************************************************************************

* Import prepared dataset
use "`interDataPath'/uk_historical.dta", clear

* Generate variables
gen m_non_dwel = NOS/ capital_stock_non_dwel*100 - cpi
gen r = gov_bond_rate - cpi

* Start and end
global year = 1855
keep if year < 2020

* De-trending
local detrend m_non_dwel r 
foreach i of varlist `detrend' {
	trends_mw20 `i' "dyn" "y" year 
}

*Saving		
keep year m_non_dwel ${trend}_m_non_dwel	
save "`interDataPath'/uk_historical_m.dta", replace

	
********************************************************************************
* US historical m (private and total available)
********************************************************************************

* Open dataset 
use "`interDataPath'/ampf_main_us.dta" ,clear

* Calculate m	
gen m_priv = NOS_priv_NS/ Kpriv_n_NS * 100 - inflation

* Start and end
global year = 1929
keep if year < 2020

*Detrend
local detrend m_priv r_hist	
foreach i of varlist `detrend' {
	trends_mw20 `i' "dyn" "y" year 
}
keep year m_priv ${trend}_m_priv
save "`interDataPath'/us_historical_m.dta", replace


********************************************************************************
* Ploting both
********************************************************************************
use "`interDataPath'/uk_historical_m.dta", clear
merge 1:1 year using "`interDataPath'/us_historical_m.dta"

tsset year

twoway tsline m_non_dwel ${trend}_m_non_dwel m_priv ${trend}_m_priv if year >= 1855, ///
    legend(label(1 "UK Return on capital") label(2 "(trend)") label(3 "US Return on capital") label(4 "(trend)") row(1) size(*1) pos(6)) ///
 	color($c1 $c1 $c3 $c3 ) ///
	lp(solid solid solid solid) ///
	lw(thin thick thin thick) ///
    ytitle("Percentage") xtitle("") title("") ///
    tlabel(1850(10)2020) ///
    graphregion(margin(r=15 b=0 t=0))
	graph export "./Figures/fig_historical_usuk_m.pdf", as(pdf) replace
	