********************************************************************************
* Replication package for: "The Four R-stars: From Interest Rates to Inflation and Back"
*     Anna Pilipentseva, Nicholas Tokay, and Ricardo Reis 
*     2025
*
*     Plotting figure appendix, G7 seires from Reis (2021)
********************************************************************************

clear all

*---------------------------------------------------------------*
* Define file paths (adjust these paths as needed)
*---------------------------------------------------------------*
*local basePath    "/Users/pilipentseva/Dropbox/Ricardo/RA-MarinaSeyed/Chile-rstar/Replication_Package"
local basePath   "/Users/r.a.reis/Dropbox/05Shared_folders/RA-CFMpredoc/Chile-rstar/Replication_Package"  // 
local rawDataPath "./Data/Raw Data"

cd "`basePath'"

********************************************************************************
* Set options for plotting and detrending
********************************************************************************
	
* Plot scheme
set scheme cleanplots
	* Colors
	global c1 green
	global c2 sand*0.8
	global c3 eltblue*1.2

*Detrending program
do Code/0_Aux_programs/trends.do
	* Detrend using Muller Watson 10-year trend
	global trend MWT
	
********************************************************************************
* Chile data
********************************************************************************

use "`rawDataPath'/CHILEDATA.dta", clear

*Chosoe time sample
drop if year < 1995
drop if year > 2019

* Trends
local detrend m_priv_eu_NS
foreach i of varlist `detrend' {
	trends_mw10 `i' "dyn" "y" year 
}

* Plotting
tset year
twoway tsline m_priv_eu_NS ${trend}_m_priv_eu_NS, ///
		legend(label(1 "Realised return") label(2 "(trend)") row(1) size(*1) pos(6)) ///
		color( $c1 $c1 ) ///
		lp(solid solid) ///
		lw(thin thick)  ///
		ytitle("Percentage") xtitle("") ///
		tlabel(2003(2)2019) ///
		ylabel(-2(2)10) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_cl_m.pdf", as(pdf) replace
