********************************************************************************
* Replication package for: "The Four R-stars: From Interest Rates to Inflation and Back"
*     Anna Pilipentseva, Nicholas Tokay, and Ricardo Reis 
*     2025
*
*     Plotting figure 2, other US variables
********************************************************************************

clear all

*---------------------------------------------------------------*
* Define file paths (adjust these paths as needed)
*---------------------------------------------------------------*
*local basePath    "/Users/pilipentseva/Dropbox/Ricardo/RA-MarinaSeyed/Chile-rstar/Replication_Package"
local basePath   "/Users/r.a.reis/Dropbox/05Shared_folders/RA-CFMpredoc/Chile-rstar/Replication_Package"  // 
local interDataPath "./Data/Intermediate Data"

cd "`basePath'"

********************************************************************************
* Set options for plotting and detrending
********************************************************************************
	
* Plot scheme
set scheme cleanplots
	* Colors
	global c1 green
	global c2 sand*0.8

*Detrending program
do Code/0_Aux_programs/trends.do
	* Detrend using Muller Watsonm 10pyear trend)
	global trend MWT

********************************************************************************
* Calculating US variables
********************************************************************************

* Annual updated data
use "`interDataPath'/ampf_main_us.dta",clear
sort year

*Investment over GDP
replace i_y=100*i_y

*Term premium
gen tp = dgs10 - dgs1

*Ratio of unproductive to productive assets
replace bh_kh = 100*bh_kh

*Rati of output to potential output
replace y_ypot = 100*(y_ypot-1)

********************************************************************************
*Detrending and choosing sample
********************************************************************************

* Start and end
global year = 1995

*Adjust data so that calculate trend using only the data that will be in the plot
drop if year < 1995
drop if year > 2019

* Trends
local detrend y_ypot i_y tp bh_kh
foreach i of varlist `detrend' {
	trends_mw10 `i' "dyn" "y" year 
}

********************************************************************************
* Ploting
********************************************************************************
tsset year
		
* Figurea 2a) k, investment over output
twoway tsline  i_y ${trend}_i_y if  year >= $year, ///
	legend(off) ///
	color($c1 $c1) ///
    lp(solid solid) ///
    lw(thin thick) ///
    ytitle("Percentage") xtitle("") ///
	tlabel(1995(5)2020) ///
	ylabel(0(5)30) ///
	graphregion(margin(r=15 b=0 t=0))
	graph export "./Figures/fig_us_investment_9519.pdf", as(pdf) replace


* Figure 2b) b/k, ratio of unproductive to productive assets
twoway tsline bh_kh ${trend}_bh_kh  if  year >= 1995, ///	
		legend(off) ///
		color($c1 $c1  ) ///
		lp(solid solid) ///
		lw(thin thick) ///
		ytitle("Percentage") xtitle("") ///
		tlabel(1995(5)2020) ///
		ylabel(0(10)100) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_us_bh_kh_9519.pdf", as(pdf) replace	
	
* Figure 2c) x/x^p, output relative to potential
twoway tsline y_ypot ${trend}_y_ypot if  year >= $year, ///
	legend(off) ///
	color($c1 $c1) ///
    lp(solid solid) ///
    lw(thin thick) ///
	yline(100, lpattern(dash)) /// Adds the horizontal dashed line at y = 1
    ytitle("Percentage") xtitle("") ///
	tlabel(1995(5)2020) ///
	graphregion(margin(r=15 b=0 t=0))
	graph export "./Figures/fig_us_ypot_9519.pdf", as(pdf) replace

* Figure 2d) t, term premium
twoway tsline tp ${trend}_tp  if  year >= 1995, ///	
		legend(off) ///
		color($c1 $c1  ) ///
		lp(solid solid) ///
		lw(thin thick) ///
		ytitle("Percentage") xtitle("") ///
		tlabel(1995(5)2020) ///
		ylabel(0(1)6) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_us_termpremium_9519.pdf", as(pdf) replace	
	



