********************************************************************************
* Replication package for: "The Four R-stars: From Interest Rates to Inflation and Back"
*     Anna Pilipentseva, Nicholas Tokay, and Ricardo Reis 
*     2025
*
*     Plotting figure appendix, G7 seires from Reis (2021)
********************************************************************************

clear all

*---------------------------------------------------------------*
* Define file paths (adjust these paths as needed)
*---------------------------------------------------------------*
*local basePath    "/Users/pilipentseva/Dropbox/Ricardo/RA-MarinaSeyed/Chile-rstar/Replication_Package"
local basePath   "/Users/r.a.reis/Dropbox/05Shared_folders/RA-CFMpredoc/Chile-rstar/Replication_Package"  // 
local rawDataPath "./Data/Raw Data"

cd "`basePath'"

********************************************************************************
* Set options for plotting and detrending
********************************************************************************
	
* Plot scheme
set scheme cleanplots
	* Colors
	global c1 green
	global c2 sand*0.8
	global c3 eltblue*1.2

*Detrending program
do Code/0_Aux_programs/trends.do
	* Detrend using Muller Watson 10-year trend
	global trend MWT
	
********************************************************************************
* The m
********************************************************************************
	
use "`rawDataPath'/ampf_main.dta" ,replace

* Start ploting from 
	global year = 1995
	keep if year <2020
	keep if year >1994

*Only the G-7
	replace G7 = 1 if alpha2 == "G7"
	keep if G7 ==1

* Plotting: Position of the line identifying the country - getting last year of available data + last value

twoway /// labels and series
		tsline m_priv_ea_NS if alpha2 == "IT" & year >= $year, color(${c1}*0.25) lp(solid) lw(thin)        || ///
		tsline m_priv_ea_NS if alpha2 == "US" & year >= $year, color(${c1}*1) lp(solid) lw(thin)            || ///
		tsline m_priv_ea_NS if alpha2 == "CA" & year >= $year, color(${c1}*0.5) lp(solid) lw(thin)        || ///
		tsline m_priv_ea_NS if alpha2 == "JP" & year >= $year, color(${c1}*0.75) lp(solid) lw(thin)        || ///
		tsline m_priv_ea_NS if alpha2 == "GB" & year >= $year, color(${c1}*1.25) lp(solid) lw(thin)        || ///
		tsline m_priv_ea_NS if alpha2 == "FR" & year >= $year, color(${c1}*1.5) lp(solid) lw(thin)        || ///
		tsline m_priv_ea_NS if alpha2 == "DE" & year >= $year, color(${c1}*1.75) lp(solid) lw(thin)            || ///
		/// aggregate and trend  
		tsline m_priv_ea_NS if alpha2 == "G7" & year >= $year, color(${c3}) lp(shortdash) lw(thick)       || /// aggegated
		tsline ${trend}_m_priv_ea_NS if alpha2 == "G7" & year >= $year, color(${c3}) lp(solid) lw(thick)  || /// trend
		, /// legend and plot
		legend(order(2 "Individual countries" 8 "Aggregate" 9 "Aggregate trend") row(1) pos(6)) ///
		ytitle("Percentage") xtitle("") note("") ///
		ylabel(-2(2)12) ///
		tlabel($year(5)2020) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_g7_m_9519.pdf", as(pdf) replace

********************************************************************************
* The y
********************************************************************************

twoway /// labels and series
		tsline r if alpha2 == "IT" & year >= $year, color(${c1}*0.25) lp(solid) lw(thin)        || ///
		tsline r if alpha2 == "US" & year >= $year, color(${c1}*1) lp(solid) lw(thin)            || ///
		tsline r if alpha2 == "CA" & year >= $year, color(${c1}*0.5) lp(solid) lw(thin)        || ///
		tsline r if alpha2 == "JP" & year >= $year, color(${c1}*0.75) lp(solid) lw(thin)        || ///
		tsline r if alpha2 == "GB" & year >= $year, color(${c1}*1.25) lp(solid) lw(thin)        || ///
		tsline r if alpha2 == "FR" & year >= $year, color(${c1}*1.5) lp(solid) lw(thin)        || ///
		tsline r if alpha2 == "DE" & year >= $year, color(${c1}*1.75) lp(solid) lw(thin)            || ///
		/// aggregate and trend  
		tsline r if alpha2 == "G7" & year >= $year, color(${c3}) lp(shortdash) lw(thick)       || /// aggegated
		tsline ${trend}_r if alpha2 == "G7" & year >= $year, color(${c3}) lp(solid) lw(thick)  || /// trend
		, /// legend and plot
		legend(order(2 "Individual countries" 8 "Aggregate" 9 "Aggregate trend") row(1) pos(6)) ///
		ytitle("Percentage") xtitle("") note("") ///
		ylabel(-2(2)12) ///
		tlabel($year(5)2020) ///
		graphregion(margin(r=15 b=0 t=0))
		graph export "./Figures/fig_g7_y_9519.pdf", as(pdf) replace

	

	
	

