% Comparative statics exercises

% Load parameters
load('paramendog2.mat'); % endogenous moving, two types
%load('paramexog2.mat'); % exogenous moving, two types
%load('paramendog1.mat'); % endogenous moving, one type

% Sizes of shocks
boom = 0.23;
longboom = 0.28;
bust = -0.048;
searcheff = 0.19;
mortgage = -0.30;
credit = -0.25;
moving = exp(0.34)-1;
types = 0.8;

% Number of exercises
ne = 14;
for i=1:ne
    p0{i} = paramvec;
    p{i} = paramvec;
end

% Number of types
q = paramvec{1}{4};

% 1
lab{1} = 'Table 3: Productivity boom';
p{1}{2}(9) = (1+boom)*p0{1}{2}(9);

% 2
lab{2} = 'Table 3: Improved search efficiency';
p{2}{2}(2) = (1+searcheff)*p0{2}{2}(2);

% 3
lab{3} = 'Table 3: Lower mortgage rates';
p{3}{2}(8) = (1+mortgage)*p0{3}{2}(8);

% 4
lab{4} = 'Table 3: Productivity & search; Table 4: first two rows; and Table 6';
p{4}{2}(9) = (1+boom)*p0{4}{2}(9);
p{4}{2}(2) = (1+searcheff)*p0{4}{2}(2);

% 5
lab{5} = 'Table 3: Productivity, search, & mortgages';
p{5}{2}(9) = (1+boom)*p0{5}{2}(9);
p{5}{2}(2) = (1+searcheff)*p0{5}{2}(2);
p{5}{2}(8) = (1+mortgage)*p0{5}{2}(8);

% 6
lab{6} = 'Table 7: Boom (1995-2006)';
p{6}{2}(9) = (1+longboom)*p0{6}{2}(9);
p{6}{2}(2) = (1+searcheff)*p0{6}{2}(2);

% 7
lab{7} = 'Table 7: Bust (2007-2009)';
p0{7} = p{6};
p{7} = p0{7};
p{7}{2}(9) = (1+bust)*p0{7}{2}(9);

% 8
lab{8} = 'Table 8: Cb';
p{8}{2}(3) = (p0{8}{2}(6) + (1+credit)*(1 - p0{8}{2}(6)) )*p0{8}{2}(3); 
p{8}{2}(6) = 1 - ((1+credit)*(1 - p0{8}{2}(6))*(p0{8}{2}(3)/p{8}{2}(6)));

% 9
lab{9} = 'Table 8: Cb, productivity, & search';
p{9}{2}(3) = (p0{9}{2}(6) + (1+credit)*(1 - p0{9}{2}(6)) )*p0{9}{2}(3); 
p{9}{2}(6) = 1 - ((1+credit)*(1 - p0{9}{2}(6))*(p0{9}{2}(3)/p{9}{2}(6)));
p{9}{2}(9) = (1+boom)*p0{9}{2}(9);
p{9}{2}(2) = (1+searcheff)*p0{9}{2}(2);

% 10
lab{10} = 'Table 9: Boom (1995-2006)';
p{10}{2}(9) = (1+longboom)*p0{10}{2}(9);
p{10}{2}(2) = (1+searcheff)*p0{10}{2}(2);
p{10}{2}(3) = (p0{10}{2}(6) + (1+credit)*(1 - p0{10}{2}(6)) )*p0{10}{2}(3); 
p{10}{2}(6) = 1 - ((1+credit)*(1 - p0{10}{2}(6))*(p0{10}{2}(3)/p{10}{2}(6)));

% 11
lab{11} = 'Table 9: Bust (2007-2009)';
p0{11} = p{10};
p{11} = p0{11};
p{11}{2}(9) = (1+bust)*p0{11}{2}(9);
p{11}{2}(3) = p0{10}{2}(3);
p{11}{2}(6) = p0{10}{2}(6);

% 12
lab{12} = 'Table 4: a1 & a2 up 34%';
if q > 1
    p{12}{1}{2} = (1+moving)*p0{12}{1}{2};
end

% 13
lab{13} = 'Table 4: theta2 0.36 to 0.65';
if q > 1
    p{13}{1}{1}(2) = (1+types)*p0{13}{1}{1}(2);
    p{13}{1}{1}(1) = 1 - p{13}{1}{1}(2);
end

% 14
lab{14} = 'Table 8: All factors';
p{14}{2}(3) = (p0{14}{2}(6) + (1+credit)*(1 - p0{14}{2}(6)) )*p0{14}{2}(3); 
p{14}{2}(6) = 1 - ((1+credit)*(1 - p0{14}{2}(6))*(p0{14}{2}(3)/p{14}{2}(6)));
p{14}{2}(9) = (1+boom)*p0{14}{2}(9);
p{14}{2}(2) = (1+searcheff)*p0{14}{2}(2);
p{14}{2}(8) = (1+mortgage)*p0{14}{2}(8);

%% Compute steady-state effects for each exercise

% Main loop
for i=1:ne
    
    % Solve model before and after
    results0{i} = solvemodel(p0{i});
    results{i} = solvemodel(p{i});
    
    % Comparative statics
    resp{i} = 100*[(log(results{i}(7)) - log(results0{i}(7))) (log(results{i}(7)) - log(results0{i}(7))) ... 
        (log(results{i}(4)) - log(results0{i}(4))) (log(results{i}(5)) - log(results0{i}(5))) ... 
        (log(results{i}(6)) - log(results0{i}(6))) (log(results{i}(8)) - log(results0{i}(8))) ];
    
end

% Report results
for i=1:ne
    disp(lab{i});
    disp('S N s n u P');
    disp(resp{i});
end
