function dist = hazdist(hazparam,hazdata,targets,dl0)
% Compute weighted distance between model and empirical hazard functions

% Unpackage hazard function parameters
np = size(hazparam,1);

% Exogenous moving
exog = ~isnan(dl0);

% Parameter vector
if exog
    
    % Number of types
    q = floor((np+1)/2);
    
    % Extract parameter vectors
    pr = hazparam(1:q-1);
    a = hazparam(q:2*q-1);
    dl = dl0*ones(q,1);
    
else
    
    % Number of types
    q = floor((np+1)/3);
    
    % Extract parameter vectors
    pr = hazparam(1:q-1);
    a = hazparam(q:2*q-1);
    dl = hazparam(2*q:3*q-1);
    
end

% Check ranges of parameters
if (min(pr) < 0)
    dist = NaN;
    return;
end
if (max(pr) > 1)
    dist = NaN;
    return;
end
if (min(a) < 0)
    dist = NaN;
    return;
end
if (min(dl) < 0)
    dist = NaN;
    return;
end
if (max(dl) > 1)
    dist = NaN;
    return;
end

% Calculate proportions of each type
theta = cumprod([1;pr]);
theta = (1/sum(theta))*theta;

% Package shock distribution parameters
idio = {theta a dl q};

% Find parameters
param = paramcalib(targets,idio);

% Check solution is valid
if isnan(param(1))
    dist = NaN;
    return;
end

% Unpackage parameters and targets
lambda = param(1);
Ts = targets(1);
Vs = targets(2);
c = targets(3);
f = targets(4);
d = targets(5);
kappa = targets(6);
omega = targets(7);
r = targets(8);

% Find x and y
rai = 1/(idio{1}'*(1./(r + idio{2})));
x_P = ((1 - kappa*c + (d/r))/(omega*((1/r) + Ts))) - f;
y_x = 1 + (c*rai)/x_P;
y = Vs^(1/lambda);
x = y/y_x;

% Package solution
results = [x;y;zeros(8,1)];
paramvec = {idio param};

% Extract empirical hazard function data
dur = hazdata{1};
hazemp = hazdata{2};
nobv = hazdata{3};
weights = hazdata{4};

% Compute model hazard function
hazmodel = hazard(paramvec,results,dur);

% Compute distance between hazard functions
dist = 100*(nobv'*(weights.*((hazmodel - hazemp).^2)));
