function crit = modelcrit(y,paramvec)
% Criterion function to find transaction threshold solution of the model

% Unpackage parameters
idio = paramvec{1};
param = paramvec{2};
lambda = param(1);
v = param(2);
C = param(3);
F = param(4);
r = param(8);
xi = param(9);

% Obtain 1/av(r+ai)
rai = 1/(idio{1}'*(1./(r + idio{2})));

% Obtain av(ai*dli/(r+ai)(r + ai*(1-dli)))
aidli = idio{1}'*( (idio{2}.*idio{3})./((r+idio{2}).*(r + idio{2}.*(1 - idio{3}))) );

% Criterion for solution of model
crit = y + (F/xi) - (C/xi)*rai - (v/(lambda-1))*( ((y^(1-lambda))/rai) + aidli*(( y - (C/xi)*rai)^(1-lambda)) );
