function calibvec = onetypecalibfunc(Tdelta,targets)
% Compute calibration criterion and parameters given targets

% Extract targets
Ts = targets(1);
Vs = targets(2);
Tn = targets(3);
eta = targets(4);
c = targets(5);
f = targets(6);
d = targets(7);
kappa = targets(8);
omega = targets(9);
r = targets(10);

% Normalization
xi = 1;

% Arrival rate of shocks
a = 1/Tdelta;

% Calculate lambda
lambda = (eta*Tdelta)/(Tn - Tdelta);

% Calculate thresholds y and x
y = Vs^(1/lambda);
x = (Vs^(1/lambda))/( 1 + (((r+a)*c)/( ((1 - kappa*c + (d/r) )/( omega*( (1/r) + Ts ) ) ) - f ) ) );

% Calculate delta
delta = ((Tn - Tdelta)/( (Tn - Tdelta) + Tdelta*((y/x)^lambda) ) )^(1/lambda);

% Calculate v
v = Vs/Ts;

% Calculate price
P = (Vs^(1/lambda))/( ((1 - kappa*c + (d/r) )/(omega*((1/r) + Ts))) + (r+a)*c - f);

% Costs
C = c*P;
F = f*P;
D = d*P;

% Criterion
crit = abs( (( x + (F/xi) )/( (v/((lambda-1)*(r+a)))*( (y^(1-lambda)) + ((a*(delta^lambda))/(r + a*(1-(delta^lambda))))*(x^(1-lambda)) ) ) ) - 1 );

% Package results
calibvec = [crit;delta;lambda;v;C;F;D;kappa;omega;r;xi];
