function results = solvemodel(paramvec)
% Solve model and return results

% Unpackage parameters
idio = paramvec{1};
param = paramvec{2};
lambda = param(1);
v = param(2);
C = param(3);
F = param(4);
D = param(5);
kappa = param(6);
omega = param(7);
r = param(8);
xi = param(9);

% Obtain 1/av(r+ai)
rai = 1/(idio{1}'*(1./(r + idio{2})));

% Create results vector
results = zeros(10,1);

% Find transaction threshold y value that satisfies criterion
y = fzero(@modelcrit,1.001,[],paramvec);

% Find moving threcshold x
x = y - rai*(C/xi);

% Selling probability
pi = y^(-lambda);

% Sales rate
s = v*pi;

% Moving rate
n = 1/( (1 - ((y/x)^lambda))*(idio{1}'*(1./idio{2})) + ((y/x)^lambda)*(idio{1}'*(1./(idio{2}.*(1-idio{3})))) );

% Unsold stock
u = n/(s+n);

% Sales volume
S = s*u;

% Average transaction price
P = kappa*C - (D/r) + omega*( (1/r) + ((y^lambda)/v) )*( xi*x + F );

% Package results
results = [x;y;pi;s;n;u;S;P];
