% Calibrate the model with a single type

% Load parameters of two type model
load('paramendog2.mat');

% Filename to save results under
filename = 'paramendog1.mat';

% Unpackage parameters
paramvec0 = paramvec;
idio0 = paramvec0{1};
theta0 = idio0{1};
a0 = idio0{2};
dl0 = idio0{3};
q0 = idio0{4};
param0 = paramvec0{2};
lambda0 = param0(1);
v0 = param0(2);
C0 = param0(3);
F0 = param0(4);
D0 = param0(5);
kappa0 = param0(6);
omega0 = param0(7);
r0 = param0(8);
xi0 = param0(9);

% Find delta
delta0 = dl0.^(1/lambda0);

% Solve model
results0 = solvemodel(paramvec0);

% Unpackage results
x0 = results0(1);
y0 = results0(2);
pi0 = results0(3);
s0 = results0(4);
n0 = results0(5);
u0 = results0(6);
S0 = results0(7);
P0 = results0(8);

% Time to sell
Ts = 1/s0;

% Viewings per sale
Vs = v0*Ts;

% Expected time in house
Tn = 1/n0;

% Elasticity of moving rate
eta = lambda0*((y0/x0)^lambda0)*(idio0{1}'*(idio0{3}./(1-idio0{3})));

% Cost ratios
c = C0/P0;
f = F0/P0;
d = D0/P0;

% Package targets
targets = [Ts;Vs;Tn;eta;c;f;d;kappa0;omega0;r0];

% Construct grid
Tdelta_min = 0.0001;
Tdelta_max = Tn - 0.00000001;
Tdelta_num = 1000;
Tdelta_step = (Tdelta_max-Tdelta_min)/(Tdelta_num-1);
Tdelta_grid = (Tdelta_min:Tdelta_step:Tdelta_max)';
crit = zeros(Tdelta_num,1);

% Evaluate criterion at each grid point
for i=1:Tdelta_num
    calibvec = onetypecalibfunc(Tdelta_grid(i),targets);
    crit(i) = calibvec(1);
end

% Find point with minimum absolute value of criterion
abscrit = abs(crit);
[critmin Tdelta_idx] = min(abscrit);

% Criterion minimizing point
Tdelta_start = Tdelta_grid(Tdelta_idx);

% Find Tdelta value that matches targets
Tdelta = fminsearch(@onetypecalibcrit,Tdelta_start,[],targets);

% Get other parameters associated with value of Tdelta
calibvec = onetypecalibfunc(Tdelta,targets);

% New parameter vector
paramvec = cell(2,1);

% Single type
q = 1;
theta = [1];

% Arrival rate of shocks
a = 1/Tdelta;

% Unpackage other parameters
delta = calibvec(2);
lambda = calibvec(3);
v = calibvec(4);
C = calibvec(5);
F = calibvec(6);
D = calibvec(7);
kappa = calibvec(8);
omega = calibvec(9);
r = calibvec(10);
xi = calibvec(11);

% delta^lambda
dl = delta^lambda;

% Assemble new parameter vector
idio = {theta a dl q};
param = [lambda;v;C;F;D;kappa;omega;r;xi];
paramvec = {idio;param};

% Save results
save(filename,'paramvec');
