function param = paramcalib(targets,idio)
% Calibrate parameters given targets and distributions of shocks

% Unpackage targets
Ts = targets(1);
Vs = targets(2);
c = targets(3);
f = targets(4);
d = targets(5);
kappa = targets(6);
omega = targets(7);
r = targets(8);

% Create parameter vector
param = zeros(9,1);

% Obtain 1/av(r+ai)
rai = 1/(idio{1}'*(1./(r + idio{2})));

% Obtain av(ai*dli/(r+ai)(r + ai*(1-dli)))
aidli = idio{1}'*( (idio{2}.*idio{3})./((r+idio{2}).*(r + idio{2}.*(1 - idio{3}))) );

% Obtain v
v = Vs/Ts;

% Obtain x/P
x_P = ((1 - kappa*c + (d/r))/(omega*((1/r) + Ts))) - f;

% Obtain y/x
y_x = 1 + (c*rai)/x_P;

% Find lambda
coeff = aidli*rai;
rhs = (Ts*(x_P + f))/( c + (x_P/rai));
lambda = findlambda(y_x,coeff,rhs,idio{3});

% Check solution is valid
if isnan(lambda)
    param = NaN*ones(9,1);
    return;
end

% Find y and x
y = Vs^(1/lambda);
x = y/y_x;

% Find P
P = x/x_P;

% Find C, F, and M
C = c*P;
F = f*P;
D = d*P;

% Normalization
xi = 1;

% Package parameters
param = [lambda;v;C;F;D;kappa;omega;r;xi];
