function mu = findmu(epsilon,eta)
% Find equilibrium value of mu for given parameters epsilon and eta

% Check eta is sufficiently high for two-price equilibrium
etastar = (3*epsilon-1) + 2*sqrt(2*epsilon*(epsilon-1));

if eta > etastar
    % Find equilibrium relative markup
    warning off MATLAB:fzero:UndeterminedSyntax;
    mu = fzero(@resultant,0.75,[],epsilon,eta);
else
    % Return one-price equilibrium
    mu = 1;
end
