% Calculate impulse response functions of DSGE model with sales

%% Options

% Parameters of model of sales
epsilon = 3.01; % elasticity of substitution between product types
eta = 19.8; % bargain hunters' elasticity of substitution between brands
lambda = 0.735; % fraction of loyal customers for each brand
sigma = 0.255; % size of sector of economy with sales

% Other parameters (monthly calibration)
beta = 0.9975; % subjective discount factor
thetac = 0.333; % intertemporal elasticity of substitution in consumption
thetah = 0.7; % Frisch elasticity of labour supply
alpha = 0.667; % elasticity of output w.r.t. hours
gamma = (1-alpha)/alpha; % elasticity of marginal cost w.r.t. output
varsigma = 20; % elasticity of substitution between differentiated labour inputs
phip = 0.889; % probability of stickiness of normal prices
phiw = 0.889; % probability of wage stickiness
p = 0.536; % first-order serial correlation of money-supply growth rate

% Impulse response functions
nt = 48; % number of time periods to generate responses for

%% Main code

% Indices of endogenous variables
ipibar = 1; % aggregate inflation
iYbar = ipibar + 1; % aggregate output
ii = iYbar + 1; % nominal interest rate
iw = ii + 1; % real wage
iwstar = iw + 1; % desired real wage
ipiW = iwstar + 1; % wage inflation
irho = ipiW + 1; % non-sale-sector price level to average normal price
ix = irho + 1; % real marginal cost in sale sector (defined using aggregate price level)
iY = ix + 1; % value-added of sale sector
iQ = iY + 1; % physical output of sale sector
iMg = iQ + 1; % growth rate of money supply

% Solve dynamic model
[Phi Theta] = solvedyn(epsilon,eta,lambda,sigma,beta,thetac,thetah,alpha,gamma,varsigma,phip,phiw,p);

% Calculate impulse response functions
ns = size(Phi,1);
impresp = zeros(nt,ns);
Psi = Theta;
for k=1:nt
    impresp(k,:) = Psi';
    Psi = Phi*Psi;
end

% Obtain impulse responses of output and price level
impr = [impresp(:,iYbar) cumsum(impresp(:,ipibar))];
