
*************************************
**** Program to run all do files ****
*************************************

* This file generates all the tables and figures in Redding and Sturm (2008)
* The Costs of Remoteness: Evidence from German Division and Reunification

* Some of the datasets used are generated by the Matlab files in
* the sub-directories calibration_simulation and grid_search

* See the readme.doc file for further details

*****************************
**** Set local directory ****
*****************************

cd Z:\SRDS\Germancities\RemotenessAER\

*******************************************
**** Main Results : Tables and Figures ****
*******************************************

* Create Figures 1-4, the main results in Tables 1-2 and 4-7, and the 
* non-parametric estimation results discussed in Section IV.C of the paper

do regressions\main_results\main_results.do

* Create Table 3 and Figure 5 based on the grid search in Section V.A of the paper. 
* This file uses data created by the Matlab program that undertakes the grid search

do grid_search\gridsearch_results_table3_figure5.do

* Create Figure 6 based on the grid search in Section V.A of the paper. This file 
* uses data created by the Matlab program that undertakes the grid search

do grid_search\bestfit_parameters_figure6.do

*********************************************
**** Technical Appendix Robustness Tests ****
*********************************************

* Robustness to the alternative sample based on a population greater than 50,000
* in 2002 discussed in Section IV.B of the paper and in more detail in Section C 
* of the web-based technical appendix

do regressions\robustness\techappendix_robustness\2002_sample_robustness.do

* Run the other robustness regressions discussed in Section IV.B of the paper 
* and in more detail in Section C of the web-based technical appendix

do regressions\robustness\techappendix_robustness\techappendix_other_robustness.do

********************************
**** Other Robustness Tests ****
********************************

* Run the Fulda gap regression discussed in Section V.E of the paper

do regressions\robustness\other_robustness\fulda_gap.do

* Run the regression for East Germany discussed in Section V.E of the paper

do regressions\robustness\other_robustness\east_germany.do
