clear all
set mem 700m
set matsize 800

* Create program for bootstrap
program tests, eclass
drop fitp fith fito xg resh resp pch pcp
local _rhs   "   ldist  border comlang colony comfrt_wto  fei_* fee_*  "
poisson y `_rhs', robust difficult technique(nr) iterate(5000) 
predict double fitp
heckman ly `_rhs', difficult robust select(`_rhs') rhoforce 
predict double fito, xb
predict double xg, xbsel
gen double fith=exp(fito+0.5*e(sigma)^2+log(normal(xg+ e(rho)*e(sigma))))
gen double resh=(y-fith)/fith
gen double pch=(fitp-fith)/fith
gen double resp=(y-fitp)/fitp
gen double pcp=(fith-fitp)/fitp
reg  resp pcp `_rhs' [aw=fitp], robust
scalar b_one=_b[pcp]
reg  resh pch `_rhs' [aw=fith], robust
ereturn scalar two=_b[pch]
ereturn scalar one=b_one
end


* Read and transform data
use "Log of Gravity.dta", clear
replace lyex=lypex-lpex
replace lyim=lypim-lpim
gen double  y = trade
gen double ly=log(y)
gen delta=y>0
qui xi, pre(fee_) i.ex_feenstra
qui xi, pre(fei_) i.im_feenstra

local _rhs   "   ldist  border comlang colony comfrt_wto  fei_* fee_*  "
unab _rhs :  `_rhs'

* Estimate models

* Estimate ECE
poisson y `_rhs', robust difficult technique(nr) iterate(5000) 
predict double fitp

* Estimate Two-Part
heckman ly `_rhs', difficult robust select(`_rhs') rhoforce 
predict double fito, xb
predict double xg, xbsel
gen double fith=exp(fito+0.5*e(sigma)^2+log(normal(xg+ e(rho)*e(sigma))))

di "correlations"
correlate y fitp fith

* HPC TESTS
gen double resh=(y-fith)/fith
gen double pch=(fitp-fith)/fith
gen double resp=(y-fitp)/fitp
gen double pcp=(fith-fitp)/fitp

di "Test One-part"
qui reg  resp pcp `_rhs' [aw=fitp], robust
di as error "p-value for the 1-part model: " 1-normal(_b[pcp]/_se[pcp])


di "Test Two-part"
qui reg  resh pch `_rhs' [aw=fith], robust
di as error "p-value for the 2-part model: " 1-normal(_b[pch]/_se[pch])


* Bootstrap
set seed 262014
qui bs e(one) e(two), reps(1000): tests
di as error "Bootstrap p-value for the 1-part model: " 1-normal(_b[_bs_1]/_se[_bs_1])
di as error "Bootstrap p-value for the 2-part model: " 1-normal(_b[_bs_2]/_se[_bs_2])

log close
