clear all
set mem 700m
set matsize 800

* Create program for bootstrap
program tests, eclass
drop fitp pfit fit2 fith resh resp pch pcp
* Estimate ECE
nl (y = exp({b0} + {b1}*age + {b2}*male + {b3}*white + {b4}*educ + {b5}*married + {b6}*xcellent + {b7}*verygood + {b8}*good))
predict double fitp, yhat
logit delta age male white educ  married xcellent verygood good
predict double pfit, p
nl (y = exp({b0} + {b1}*age + {b2}*male + {b3}*white + {b4}*educ + {b5}*married + {b6}*xcellent + {b7}*verygood + {b8}*good)) if delta==1
predict double fit2, yhat
g double fith = pfit*fit2
gen double resh=(y-fith)/fith
gen double pch=(fitp-fith)/fith
gen double resp=(y-fitp)/fitp
gen double pcp=(fith-fitp)/fitp
reg  resp pcp age male white educ  married xcellent verygood good [aw=fitp], robust
scalar b_one=_b[pcp]
reg  resh pch age male white educ  married xcellent verygood good [aw=fith], robust
ereturn scalar two=_b[pch]
ereturn scalar one=b_one
end


* Read and transform data
use muchado.dta, clear

gen double   y = dv12
gen delta=y>0

* Estimate models

* Estimate ECE
nl (y = exp({b0} + {b1}*age + {b2}*male + {b3}*white + {b4}*educ + {b5}*married + {b6}*xcellent + {b7}*verygood + {b8}*good))
predict double fitp, yhat

* Estimate Two-Part
logit delta age male white educ  married xcellent verygood good
predict double pfit, p
nl (y = exp({b0} + {b1}*age + {b2}*male + {b3}*white + {b4}*educ + {b5}*married + {b6}*xcellent + {b7}*verygood + {b8}*good)) if delta==1
predict double fit2, yhat
g double fith = pfit*fit2

di "correlations"
correlate y fitp fith

* HPC TESTS
gen double resh=(y-fith)/fith
gen double pch=(fitp-fith)/fith
gen double resp=(y-fitp)/fitp
gen double pcp=(fith-fitp)/fitp

di "Test One-part"
qui reg  resp pcp age male white educ  married xcellent verygood good [aw=fitp], robust
di as error "p-value for the 1-part model: " 1-normal(_b[pcp]/_se[pcp])


di "Test Two-part"
qui reg  resh pch age male white educ  married xcellent verygood good [aw=fith], robust
di as error "p-value for the 2-part model: " 1-normal(_b[pch]/_se[pch])


* Bootstrap
set seed 262014
qui bs e(one) e(two), reps(1000): tests
di as error "Bootstrap p-value for the 1-part model: " 1-normal(_b[_bs_1]/_se[_bs_1])
di as error "Bootstrap p-value for the 2-part model: " 1-normal(_b[_bs_2]/_se[_bs_2])

log close
