//*******REPLICATION PROGRAM************

//*******DATASET1**********
use "climate_laws_merge.dta", clear
gen decade=0 if year<1970
replace decade=1 if year>=1970 & year<1980
replace decade=2 if year>=1980 & year<1990
replace decade=3 if year>=1990 & year<2000
replace decade=4 if year>=2000 & year<2010
replace decade=5 if year>=2010 & year<2020
label define decade 1 "1970-1979" 2 "1980-1989" 3 "1990-1999" 4 "2000-2009" 5 "2010-2019"
label values decade decade

//TABLE 5
total laws_passed policies_passed, over(decade)
//TABLE 6
total adaptation_policies - actions_passed, over(decade)

//*******DATASET2**********
use "quantified_pledges.dta", clear
//TABLE 3
//Number of signatories
tab Party if Pledge=="Kyoto" & country!="EU28"
tab Party if Pledge=="Copenhagen Accord" & country!="EU28"
tab Party if Pledge=="Paris" & country!="EU28"
//Number of countries with quantified objectives
tab Quantified if Pledge=="Kyoto" & country!="EU28" & Quantified!="."
tab Quantified if Pledge=="Copenhagen Accord" & country!="EU28" & Quantified!="."
tab Quantified if Pledge=="Paris" & country!="EU28" & Quantified!="."
//Number of countries with quantifiable objectives
sum abso_reduction_high if Pledge=="Kyoto" & country!="EU28" & abso_reduction_high!=0
sum abso_reduction_high if Pledge=="Copenhagen Accord" & country!="EU28" & abso_reduction_high!=0
sum abso_reduction_high if Pledge=="Paris" & country!="EU28" & abso_reduction_high!=0

//Total targeted reduction
total abso_reduction_high if Pledge=="Kyoto" & country!="EU28" & QuantifiedOb!="."
total abso_reduction_high if Pledge=="Kyoto" & country!="EU28" & QuantifiedOb!="." & country!="Russian Federation"

total abso_reduction_high if Pledge=="Copenhagen Accord" & country!="EU28" & QuantifiedOb!="."
total abso_reduction_high if Pledge=="Paris" & country!="EU28" & QuantifiedOb!="."
total abso_reduction_low if Pledge=="Kyoto" & country!="EU28" & QuantifiedOb!="."
total abso_reduction_low if Pledge=="Kyoto" & country!="EU28" & QuantifiedOb!="." & country!="Russian Federation"

total abso_reduction_low if Pledge=="Copenhagen Accord" & country!="EU28" & QuantifiedOb!="."
total abso_reduction_low if Pledge=="Paris" & country!="EU28" & QuantifiedOb!="."

//Targets for Europe
total abso_reduction_high if Pledge=="Kyoto" & country!="EU28" & QuantifiedOb!="." & (country=="Austria" | country=="Belgium" | ///
	country=="Denmark" | country=="Finland" | country=="France" | country=="Germany" | country=="Greece" | ///
	country=="Italy" | country=="Ireland" | country=="Luxembourg" | country=="Netherlands" | country=="Portugal" | ///
	country=="Spain" | country=="Sweden" | country=="United Kingdom" )

total GHG_total_start if Pledge=="Kyoto" & country!="EU28" & QuantifiedOb!="." & (country=="Austria" | country=="Belgium" | ///
	country=="Denmark" | country=="Finland" | country=="France" | country=="Germany" | country=="Greece" | ///
	country=="Italy" | country=="Ireland" | country=="Luxembourg" | country=="Netherlands" | country=="Portugal" | ///
	country=="Spain" | country=="Sweden" | country=="United Kingdom" )

//Total emissions at start - used to compute contributions by signatory countries (total emissions taken from "policy_analysis280521.dta")
total GHG_total_start if Pledge=="Kyoto"  & country!="EU28" & abso_reduction_high!=. & Quantified!="."
total GHG_total_start if Pledge=="Kyoto"  & country!="EU28" & abso_reduction_high!=. & Quantified!="." & country!="Russian Federation"
total GHG_total_start if Pledge=="Kyoto"  & country!="EU28" & Party=="Yes"
total GHG_total_start if Pledge=="Kyoto"  & country!="EU28" & Party=="Yes" & country!="Russian Federation"

total GHG_total_start if Pledge=="Copenhagen Accord"  & country!="EU28" & abso_reduction_high!=. & Quantified!="."
total GHG_total_start if Pledge=="Copenhagen Accord"  & country!="EU28" & Party=="Yes"

total GHG_total_start if Pledge=="Paris"  & country!="EU28" & abso_reduction_high!=. & Quantified!="."
total GHG_total_start if Pledge=="Paris"  & country!="EU28" & Party=="Yes"

//*******DATASET3**********
use "policy_analysis.dta", clear

//Data preparation
gen emissionpc70=total_fossil_co2_percapita if year==1970
bysort country: egen emissions1970_pc=mean(emissionpc70)
drop emissionpc70
gen emissionpc18=total_fossil_co2_percapita if year==2018
bysort country: egen emissions2018_pc=mean(emissionpc18)
drop emissionpc18

gen emission70=total_fossil_co2_emissions if year==1970
bysort country: egen emissions1970=mean(emission70)
drop emission70
gen emission10=total_fossil_co2_emissions if year==2010
bysort country: egen emissions2010=mean(emission10)
drop emission10
gen emission18=total_fossil_co2_emissions if year==2018
bysort country: egen emissions2018=mean(emission18)
drop emission18

gen ghgemission05=GHG_incLULUCF if year==2005
bysort country: egen ghgemissions2005=mean(ghgemission05)
drop ghgemission05

gen sample=1 if emissions1970!=. & emissions1970_pc!=. & emissions2018!=. & emissions2018_pc!=. & population!=.

gen aggregate=1 if country=="EU28" | country=="World" | country=="International Aviation" | country=="International Shipping"

gen dghg2005=ghgemissions2005-GHG_incLULUCF if year==2012
gen dghg2005_rel=(ghgemissions2005-GHG_incLULUCF)*100/ghgemissions2005 if year==2012

gen d1emissions2010=emissions2010-emissions2018
gen d1emissions2010_rel=(emissions2010-emissions2018)*100/emissions2010

gen signed_kyoto=1 if year>=2005 & partytopledge2==1
replace signed_kyoto=0 if signed_kyoto==.
gen signed_copenhagen=1 if year>=2010 & partytopledge1==1
replace signed_copenhagen=0 if signed_copenhagen==.
gen signed_paris=1 if year>=2017 & partytopledge3==1
replace signed_paris=0 if signed_paris==.

gen quantobj_kyoto=1 if upperbound2!=. & year>=2005
replace quantobj_kyoto=0 if quantobj_kyoto==.
gen quantobj_cope=1 if upperbound1!=. & year>=2010
replace quantobj_cope=0 if quantobj_cope==.
gen quantobj_paris=1 if upperbound3!=. & year>=2017
replace quantobj_paris=0 if quantobj_paris==.

gen quantobj=1 if quantobj_kyoto==1 | quantobj_cope==1 | quantobj_paris==1
replace quantobj=0 if quantobj==.

gen country_with_law=1 if cum_laws!=0 & cum_laws!=.
replace country_with_law=0 if country_with_law==. & cum_laws!=.
gen country_with_policy=1 if cum_policies!=0 & cum_policies!=.
replace country_with_policy=0 if country_with_policy==. & cum_policies!=.

gen have_carbontax=cum_CT
replace have_carbontax=1 if have_carbontax==2
gen have_emissiontrade=cum_ETS
replace have_emissiontrade=1 if have_emissiontrade==2

gen ln_gdp=ln(GDP)
gen ln_gdp_percapita=ln(GDP_percapita)
gen ln_population=ln(population)

gen ln_total_emissions=ln( total_fossil_co2_emissions)
gen ln_percapita_emissions=ln( total_fossil_co2_percapita)

tsset cntry year, yearly

gen lemissions = ln_total_emissions
gen dlemissions = d.lemissions
gen dgdppc = d.ln_gdp_percapita
gen dlpop = d.ln_population
gen dlurb = d.urban_pop
gen gdppc = ln_gdp_percapita
gen lpop = ln_population
gen lurb = urban_pop
gen gdp = ln_gdp
gen dgdp = GDP_growth

gen kyoto=signed_kyoto
gen cope=signed_cope
gen laws=cum_laws
gen policies=cum_policies
gen carbontax=have_carbontax
gen ets=have_emissiontrade


//********TABLES*********
//TABLE 1 - regional descriptives
foreach i in 1 2 3 4 5 6 7 {
	sum emissions1970_pc emissions2018_pc [aweight=population] if wbregion==`i' & year==2018 & sample==1
}

foreach i in 1 2 3 4 5 6 7 {
	total emissions1970 emissions2018 if wbregion==`i' & year==2018 & sample==1
}

//Country level information on top emitters extracted directly from EDGAR dataset

//TABLE 2 - extracted directly from EDGAR dataset

//TABLE 3 remaining information - start year emissions to compute contributions of signatory countries
total GHG_incLULUCF if year==2005 & aggregate!=1 //Kyoto

total GHG_incLULUCF if year==2010 & aggregate!=1 //Copenhagen

total GHG_incLULUCF if year==2014 & aggregate!=1 //Paris

//TABLE 4 - Comparison with non-signatories
bysort signed_kyoto: sum dghg2005_rel [aweight=ghgemissions2005] if ghgemissions2005>0 & ghgemissions2005!=. & aggregate!=1, det
bysort signed_cope: sum d1emissions2010_rel [aweight=emissions2010]  if aggregate!=1 & year==2010, det

//TABLE 5 and 6 - using "climate_laws_merge.dta"

//TABLE 5
total country_with_law country_with_policy if year==1979
total country_with_law country_with_policy if year==1989
total country_with_law country_with_policy if year==1999
total country_with_law country_with_policy if year==2009
total country_with_law country_with_policy if year==2018

//TABLE 7
total have_carbontax have_emissiontrade if year==1979 & country!="EU28"
total have_carbontax have_emissiontrade if year==1989 & country!="EU28"
total have_carbontax have_emissiontrade if year==1999 & country!="EU28"
total have_carbontax have_emissiontrade if year==2009 & country!="EU28" 
total have_carbontax have_emissiontrade if year==2018 & country!="EU28"

total cum_CT cum_ETS cum_CT_sn cum_ETS_sn  if year==1999 & country!="EU28"
total cum_CT cum_ETS cum_CT_sn cum_ETS_sn  if year==2009 & country!="EU28"
total cum_CT cum_ETS cum_CT_sn cum_ETS_sn  if year==2018 & country!="EU28"

//TABLE 8 - Base regression
qui reg ln_total_emissions ln_gdp_percapita ln_population urban_pop, robust
eststo reg1
qui xtreg ln_total_emissions  ln_gdp_percapita ln_population urban_pop i.year, fe robust
eststo reg1fe
qui reg ln_total_emissions  ln_gdp_percapita ln_population urban_pop oil_rents, robust
eststo reg1a
qui xtreg ln_total_emissions  ln_gdp_percapita ln_population urban_pop oil_rents i.year, fe robust
eststo reg1afe

esttab reg1 reg1fe reg1a reg1afe,  ///
	star(* 0.1 ** 0.05 *** 0.01) se(3) b(3) n scalars(r2_o) brackets nogaps drop(*.year _cons) varwidth(30)
	
//APPENDIX TABLE B1	- stability of coefficients across development levels
encode Incomegroup, gen(inc_group)
qui xtreg ln_total_emissions  i.inc_group##c.ln_gdp_percapita i.inc_group##c.ln_population i.inc_group##c.urban_pop i.year, fe robust
eststo incgroup_stability
qui xtreg ln_total_emissions  i.inc_group##c.ln_gdp_percapita i.inc_group##c.ln_population i.inc_group##c.urban_pop i.year if year<2000, fe robust
eststo incgroup_stability_pre

esttab incgroup_stability incgroup_stability_pre,  nobaselevels ///
	star(* 0.1 ** 0.05 *** 0.01) se(3) b(3) n scalars(r2_o) brackets nogaps drop(*.year _cons) varwidth(30) ///
	mtitles("Full period" "Pre-period" )

//APPENDIX TABLE B2 - stability of coefficients across time
gen decade=1 if year>=1970 & year<1980
replace decade=2 if year>=1980 & year<1990
replace decade=3 if year>=1990 & year<2000
replace decade=4 if year>=2000 & year<2010
replace decade=5 if year>=2010 & year<2020

qui xtreg ln_total_emissions  i.decade##c.ln_gdp_percapita i.decade##c.ln_population i.decade##c.urban_pop, fe robust
eststo time_stability
qui xtreg ln_total_emissions i.decade##c.ln_gdp_percapita i.decade##c.ln_population i.decade##c.urban_pop if year<2000, fe robust
eststo time_stability_pre
qui xtreg ln_total_emissions i.decade##c.ln_gdp_percapita i.decade##c.ln_population i.decade##c.urban_pop if year>1991, fe robust
eststo time_stability_post

esttab time_stability time_stability_pre time_stability_post,  nobaselevels ///
	star(* 0.1 ** 0.05 *** 0.01) se(3) b(3) n scalars(r2_o) brackets nogaps drop(_cons) varwidth(30) ///
	mtitles("Full sample" "Pre-period" "During and post")
	
//CONSTRUCTION OF PROPENSITY SCORES
//Obtain propensity scores and weights for pledges
xtset cntry year, yearly

probit signed_kyoto l1.lemissions gdppc lpop lurb if year==2005
predict phat_kyo if year==2005
gen w1_kyo=signed_kyoto/phat_kyo + (1-signed_kyoto)*(1/(1-phat_kyo)) if year==2005
bysort country: egen w_kyo1=mean(w1_kyo)

gen phat_kyo1=phat_kyo
replace phat_kyo1=0.9 if phat_kyo>0.9 & phat_kyo!=. & year==2005
replace phat_kyo1=0.1 if phat_kyo<0.1 & year==2005
gen w2_kyo=signed_kyoto/phat_kyo1 + (1-signed_kyoto)*(1/(1-phat_kyo1)) if year==2005
bysort country: egen w_kyo2=mean(w2_kyo)

xtset cntry year, yearly
probit signed_cope l1.lemissions l1.gdppc l1.lpop l1.lurb if year==2010 //since signed end of 2009
predict phat_cop if year==2010
gen w1_cop=signed_cope/phat_cop + (1-signed_cope)*(1/(1-phat_cop)) if year==2010
bysort country: egen w_cop1=mean(w1_cop)

gen phat_cop1=phat_cop
replace phat_cop1=0.9 if phat_cop>0.9 & phat_cop!=. & year==2010
replace phat_cop1=0.1 if phat_cop<0.1 & year==2010
gen w2_cop=signed_cope/phat_cop1 + (1-signed_cope)*(1/(1-phat_cop1)) if year==2010
bysort country: egen w_cop2=mean(w2_cop)

xtset cntry year, yearly
probit signed_par l1.lemissions l1.gdppc l1.lpop l1.lurb if year==2017 //since signed end of 2016
predict phat_par if year==2017
gen w1_par=signed_par/phat_par + (1-signed_par)*(1/(1-phat_par)) if year==2017
bysort country: egen w_par1=mean(w1_par)

gen phat_par1=phat_par
replace phat_par1=0.9 if phat_par>0.9 & phat_par!=. & year==2017
replace phat_par1=0.1 if phat_par<0.1 & year==2017
gen w2_par=signed_par/phat_par1 + (1-signed_par)*(1/(1-phat_par1)) if year==2017
bysort country: egen w_par2=mean(w2_par)

//Compile panel of propensity scores - untruncated
gen w1=w_kyo1 if year>=2005 & year<2010
replace w1=w_cop1 if year>=2010 & year<2016 & signed_kyoto==0
replace w1=1 if year>=2010 & year<2016 & signed_kyoto==1
replace w1=w_par1 if year>=2016 & year!=. & signed_cope==0
replace w1=1 if year>=2016 & year!=. & signed_cope==1
replace w1=1 if year<2005

//Truncated weights
gen w2=w_kyo2 if year>=2005 & year<2010
replace w2=w_cop2 if year>=2010 & year<2016 & signed_kyoto==0
replace w2=1.11 if year>=2010 & year<2016 & signed_kyoto==1
replace w2=w_par2 if year>=2016 & year!=. & signed_cope==0
replace w2=1.11 if year>=2016 & year!=. & signed_cope==1
replace w2=1.11 if year<2005

gen w3=w_kyo2 if year<=2005 
replace w3=w_cop2 if year<=2010 & year>2005 & signed_kyoto==0
replace w3=1.11 if year<=2010 & year>2005 & signed_kyoto==1
replace w3=w_par2 if year>2010 & year!=. & signed_cope==0
replace w3=1.11 if year>2010 & year!=. & signed_cope==1

//TABLES 9 and 10
xtset cntry year, yearly

reg ln_total_emissions L1.signed_kyoto L1.signed_cope L1.signed_paris ln_gdp_percapita ln_population urban_pop i.cntry i.year [pw=w3], robust
eststo t1
reg ln_total_emissions L1.signed_kyoto L1.signed_cope L1.signed_paris L1.quantobj ln_gdp_percapita ln_population urban_pop i.cntry i.year [pw=w3], robust
eststo t2
reg ln_total_emissions L1.cum_laws L1.cum_policies L1.have_carbontax L1.have_emissiontrade ln_gdp_percapita ln_population urban_pop i.cntry i.year [pw=w3], robust
eststo t3
reg ln_total_emissions L1.have_carbontax L1.have_emissiontrade L1.cum_adaptation_policies L1.cum_demand_policies L1.cum_supply_policies ///
	L1.cum_transport_policies L1.cum_lulucf_policies L1.cum_randd_policies ln_gdp_percapita ln_population urban_pop i.cntry i.year [pw=w3], robust
eststo t4


reg ln_total_emissions L1.signed_kyoto L1.signed_cope L1.signed_paris ln_gdp_percapita ln_population urban_pop i.cntry i.year if w3!=., robust
eststo ols1
reg ln_total_emissions L1.signed_kyoto L1.signed_cope L1.signed_paris L1.quantobj ln_gdp_percapita ln_population urban_pop i.cntry i.year if w3!=., robust
eststo ols2
reg ln_total_emissions L1.cum_laws L1.cum_policies L1.have_carbontax L1.have_emissiontrade ln_gdp_percapita ln_population urban_pop i.cntry i.year if w3!=., robust
eststo ols3
reg ln_total_emissions L1.have_carbontax L1.have_emissiontrade L1.cum_adaptation_policies L1.cum_demand_policies L1.cum_supply_policies ///
	L1.cum_transport_policies L1.cum_lulucf_policies L1.cum_randd_policies ln_gdp_percapita ln_population urban_pop i.cntry i.year if w3!=., robust
eststo ols4

//tabulate
esttab ols1 t1 ols2 t2,  ///
	star(* 0.1 ** 0.05 *** 0.01) se(3) b(3) n scalars(r2) brackets nogaps drop(*.year *.cntry ln_gdp_percapita ln_population urban_pop _cons) noomitted 
	
esttab ols3 t3 ols4 t4,  ///
	star(* 0.1 ** 0.05 *** 0.01) se(3) b(3) n scalars(r2) brackets nogaps drop(*.year *.cntry ln_gdp_percapita ln_population urban_pop _cons) noomitted varwidth(30)

//APPENDIX TABLE C1 - Placebo test
xtreg ln_total_emissions F(1).signed_kyoto L(0/1).signed_kyoto F(1).signed_cope L(0/1).signed_cope F(1).signed_paris L(0/1).signed_paris ln_gdp_percapita ln_population urban_pop ///
 i.year if w3!=., fe robust
eststo placebo

esttab placebo, star(* 0.1 ** 0.05 *** 0.01) se(3) b(3) n scalars(r2) brackets nogaps drop(*.year ln_gdp_percapita ln_population urban_pop _cons) noomitted 

//APPENDIX D - Sensitivity to outliers
reg ln_total_emissions L1.signed_kyoto L1.signed_cope L1.signed_paris ln_gdp_percapita ln_population urban_pop i.cntry i.year if w3!=. & CountryCode!="SWE" & CountryCode!="LVA" & CountryCode!="SRB"  & CountryCode!="UKR", robust
eststo ols1
reg ln_total_emissions L1.signed_kyoto L1.signed_cope L1.signed_paris L1.quantobj ln_gdp_percapita ln_population urban_pop i.cntry i.year if w3!=. & CountryCode!="SWE" & CountryCode!="LVA" & CountryCode!="SRB"  & CountryCode!="UKR", robust
eststo ols2
reg ln_total_emissions L1.cum_laws L1.cum_policies L1.have_carbontax L1.have_emissiontrade ln_gdp_percapita ln_population urban_pop i.cntry i.year if w3!=. & CountryCode!="SWE" & CountryCode!="LVA" & CountryCode!="SRB"  & CountryCode!="UKR", robust
eststo ols3
reg ln_total_emissions L1.have_carbontax L1.have_emissiontrade L1.cum_adaptation_policies L1.cum_demand_policies L1.cum_supply_policies ///
	L1.cum_transport_policies L1.cum_lulucf_policies L1.cum_randd_policies ln_gdp_percapita ln_population urban_pop i.cntry i.year if w3!=. & CountryCode!="SWE" & CountryCode!="LVA" & CountryCode!="SRB"  & CountryCode!="UKR", robust
eststo ols4

reg ln_total_emissions L1.signed_kyoto L1.signed_cope L1.signed_paris ln_gdp_percapita ln_population urban_pop i.cntry i.year [pw=w3] if CountryCode!="SWE" & CountryCode!="LVA" & CountryCode!="SRB"  & CountryCode!="UKR", robust
eststo t1
reg ln_total_emissions L1.signed_kyoto L1.signed_cope L1.signed_paris L1.quantobj ln_gdp_percapita ln_population urban_pop i.cntry i.year [pw=w3] if CountryCode!="SWE" & CountryCode!="LVA" & CountryCode!="SRB"  & CountryCode!="UKR", robust
eststo t2
reg ln_total_emissions L1.cum_laws L1.cum_policies L1.have_carbontax L1.have_emissiontrade ln_gdp_percapita ln_population urban_pop i.cntry i.year [pw=w3] if CountryCode!="SWE" & CountryCode!="LVA" & CountryCode!="SRB"  & CountryCode!="UKR", robust
eststo t3
reg ln_total_emissions L1.have_carbontax L1.have_emissiontrade L1.cum_adaptation_policies L1.cum_demand_policies L1.cum_supply_policies ///
	L1.cum_transport_policies L1.cum_lulucf_policies L1.cum_randd_policies ln_gdp_percapita ln_population urban_pop i.cntry i.year [pw=w3] if CountryCode!="SWE" & CountryCode!="LVA" & CountryCode!="SRB"  & CountryCode!="UKR", robust
eststo t4

esttab ols1 t1 ols2 t2,  ///
	star(* 0.1 ** 0.05 *** 0.01) se(3) b(3) n scalars(r2) brackets nogaps drop(*.year *.cntry ln_gdp_percapita ln_population urban_pop _cons) noomitted 
	
esttab ols3 t3 ols4 t4,  ///
	star(* 0.1 ** 0.05 *** 0.01) se(3) b(3) n scalars(r2) brackets nogaps drop(*.year *.cntry ln_gdp_percapita ln_population urban_pop _cons) noomitted 


//*****FIGURES********
gen regional_total_fossil=.
quietly forvalues i=1970/2018 {
	forvalues j=1/7 {
		total total_fossil_co2_emissions if year==`i' & wbregion==`j'
		mat b=e(b)
		replace regional_total_fossil=b[1,1] if year==`i' & wbregion==`j'
	}
}

gen regional_percapita=.
quietly forvalues i=1970/2018 {
	forvalues j=1/7 {
		sum total_fossil_co2_percapita [aweight=population] if year==`i' & wbregion==`j'
		replace regional_percapita=r(mean) if year==`i' & wbregion==`j'
	}
}

xtile total_perc= total_fossil_co2_emissions if year==2018 & aggregate!=1, nq(100)
xtile percap_perc= total_fossil_co2_percapita if year==2018 & aggregate!=1, nq(100)
gen emitters=CountryCode if (percap_perc>=90 & percap_perc!=.) | ( total_perc>=90 & total_perc!=.)

egen label_pos=mlabvpos( ln_percapita_emis ln_total_emission ) if emitters!="" & year==2018 

xtile total_perc70= total_fossil_co2_emissions if year==1970 & aggregate!=1, nq(100)
xtile percap_perc70= total_fossil_co2_percapita if year==1970 & aggregate!=1, nq(100)
gen emitters70=CountryCode if (percap_perc70>=90 & percap_perc70!=.) | ( total_perc70>=90 & total_perc70!=.)

egen label_pos70=mlabvpos( ln_percapita_emis ln_total_emission ) if emitters70!="" & year==1970 

bysort country: egen percentile1970=mean(total_perc70)
gen top_emitters70=1 if percentile1970>=96 & aggregate!=1
bysort country: egen percentile2018=mean(total_perc)
gen top_emitters2018=1 if percentile2018>=96 & aggregate!=1

gen ln_kyoto_start=ln(GHG_total_start2)
gen ln_cope_start=ln(GHG_total_start1)
gen ln_paris_start=ln(GHG_total_start3)


//FIGURE 1 - Global trends
twoway (line total_fossil_co2_percapita year if country=="World", sort ) (line GHG_percapita year if country=="World", sort), ytitle(tCO2/ tCO2 eq) legend(order(1 "Fossil CO2 emissions" 2 "GHG emissions")) title(Per capita emissions) xtitle(Year) name(pc,replace)
twoway (line total_fossil_co2_emissions year if country=="World", sort ) (line GHG_total year if country=="World", sort), ytitle(mtCO2/ mtCO2 eq) legend(order(1 "Fossil CO2 emissions" 2 "GHG emissions")) title(Total emissions) xtitle(Year) name(total,replace)

grc1leg total pc, legendfrom(total)

//FIGURE 2 - Regional total and per capita emissions
twoway (line regional_total_fossil year if country=="Canada" & year>=1970 & year<=2018, sort lwidth(medthick)) ///
(line regional_total_fossil year if country=="Germany" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(dash)) ///
(line regional_total_fossil year if country=="China" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(dash_dot)) ///
(line regional_total_fossil year if country=="Brazil" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(longdash_dot)) ///
(line regional_total_fossil year if country=="Libya" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(shortdash)) ///
(line regional_total_fossil year if country=="India" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(shortdash_dot)) ///
(line regional_total_fossil year if country=="Botswana" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(longdash)), ///
ytitle("Total fossil CO2 emissions (mt)", margin(medium)) xlabel(1970 1980 1990 2000 2005 "Kyoto" 2010 "Copen" 2016 "Paris", angle(45)) ///
 xscale(range(1970 2018)) legend(order(1 "North America" 2 "Europe and Central Asia" 3 "East Asia and Pacific" 4 "Latin America and Caribbean" ///
	5 "Middle East and North Africa" 6 "South Asia" 7 "Sub Saharan Africa") size(small) span) name(total, replace) xline(2005 2010 2016)
	
twoway (line regional_percapita year if country=="Canada" & year>=1970 & year<=2018, sort lwidth(medthick)) ///
(line regional_percapita year if country=="Germany" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(dash)) ///
(line regional_percapita year if country=="China" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(dash_dot)) ///
(line regional_percapita year if country=="Brazil" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(longdash_dot)) ///
(line regional_percapita year if country=="Libya" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(shortdash)) ///
(line regional_percapita year if country=="India" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(shortdash_dot)) ///
(line regional_percapita year if country=="Botswana" & year>=1970 & year<=2018, sort lwidth(medthick) lpattern(longdash)), ///
 ytitle("Per capita fossil CO2 emissions", margin(medium)) ///
 xlabel(1970 1980 1990 2000 2005 "Kyoto" 2010 "Copen" 2016 "Paris", angle(45)) xscale(range(1970 2018)) ///
 legend(order(1 "North America" 2 "Europe and Central Asia" 3 "East Asia and Pacific" 4 "Latin America and Caribbean" ///
	5 "Middle East and North Africa" 6 "South Asia" 7 "Sub Saharan Africa") size(small) span) name(percapita, replace) xline(2005 2010 2016)

grc1leg total percapita, legendfrom(total)

 //FIGURE 3 - total and per capita emissions
twoway (scatter ln_percapita_emissi ln_total_emissions if wbregion==1, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos) ) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==2, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==3, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==4, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==5, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==6, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==7, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
if year==2018 & aggregate!=1, legend(order(1 "East Asia/Pacific" 2 "Europe/Central Asia" ///
	3 "Latin America/Caribbean" 4 "Middle East/North Africa" 5 "North America" ///
	6 "South Asia" 7 "Sub-Saharan Africa") size(vsmall) col(3)) ///
	xtitle("ln(total emissions)") ytitle("ln(Per capita emissions)") title("2018") name(y2018, replace)

twoway (scatter ln_percapita_emissi ln_total_emissions if wbregion==1, mlabel(emitters70) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==2, mlabel(emitters70) mlabsize(vsmall) mlabvpos(label_pos70)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==3, mlabel(emitters70) mlabsize(vsmall) mlabvpos(label_pos70)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==4, mlabel(emitters70) mlabsize(vsmall) mlabvpos(label_pos70)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==5, mlabel(emitters70) mlabsize(vsmall) mlabvpos(label_pos70)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==6, mlabel(emitters70) mlabsize(vsmall) mlabvpos(label_pos70)) ///
(scatter ln_percapita_emissi ln_total_emissions if wbregion==7, mlabel(emitters70) mlabsize(vsmall) mlabvpos(label_pos70)) ///
if year==1970 & aggregate!=1, legend(order(1 "East Asia/Pacific" 2 "Europe/Central Asia" ///
	3 "Latin America/Caribbean" 4 "Middle East/North Africa" 5 "North America" ///
	6 "South Asia" 7 "Sub-Saharan Africa") size(vsmall) col(3)) ///
	xtitle("ln(total emissions)") ytitle("ln(Per capita emissions)") title("1970") name(y1970, replace)

 grc1leg y1970 y2018, legendfrom(y1970) ycommon xcommon


 //FIGURE 4 - Emissions income relationship
 twoway (scatter ln_percapita_emissi ln_gdp_percapita if wbregion==1, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos) ) ///
(scatter ln_percapita_emissi ln_gdp_percapita if wbregion==2, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_gdp_percapita if wbregion==3, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_gdp_percapita if wbregion==4, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_gdp_percapita if wbregion==5, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_gdp_percapita if wbregion==6, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter ln_percapita_emissi ln_gdp_percapita if wbregion==7, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(lowess  ln_percapita_emissi ln_gdp_percapita, lwidth(medthick) lcolor(black)) ///
if year==2018 & aggregate!=1, legend(order(1 "East Asia/Pacific" 2 "Europe/Central Asia" ///
	3 "Latin America/Caribbean" 4 "Middle East/North Africa" 5 "North America" ///
	6 "South Asia" 7 "Sub-Saharan Africa") size(vsmall) col(3)) ///
	xtitle("ln(GDP per capita)") ytitle("ln(Per capita emissions)") name(gdp_pce, replace)

twoway (scatter  ln_total_emissions ln_gdp_percapita if wbregion==1, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos) ) ///
(scatter  ln_total_emissions ln_gdp_percapita if wbregion==2, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter  ln_total_emissions ln_gdp_percapita if wbregion==3, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter  ln_total_emissions ln_gdp_percapita if wbregion==4, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter  ln_total_emissions ln_gdp_percapita if wbregion==5, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter  ln_total_emissions ln_gdp_percapita if wbregion==6, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(scatter  ln_total_emissions ln_gdp_percapita if wbregion==7, mlabel(emitters) mlabsize(vsmall) mlabvpos(label_pos)) ///
(lowess  ln_total_emissions ln_gdp_percapita, lwidth(medthick) lcolor(black)) ///
if year==2018 & aggregate!=1, legend(order(1 "East Asia/Pacific" 2 "Europe/Central Asia" ///
	3 "Latin America/Caribbean" 4 "Middle East/North Africa" 5 "North America" ///
	6 "South Asia" 7 "Sub-Saharan Africa") size(vsmall) col(3)) ///
	xtitle("ln(GDP per capita)") ytitle("ln(Total emissions)")  name(gdp_te, replace)
	
	grc1leg gdp_pce gdp_te, legendfrom(gdp_pce)  xcommon


//FIGURE 5 - Top emitters
xtline ln_percapita_emissions if (top_emitters2018==1 | country=="World"), overlay i(country) t(year) ///
	ytitle(ln(Per capita emissions))  addplot(scatter ln_percapita_emissions year if year==2018 & ///
	(top_emitters2018==1 | country=="World"), ms(i) mlabel(CountryCode) mlabcolor(black) mlabsize(vsmall)) name(pc, replace)
xtline ln_total_emissions if (top_emitters2018==1), overlay i(country) t(year) ///
	ytitle(ln(total emissions))  addplot(scatter ln_total_emissions year if year==2018 & ///
	(top_emitters2018==1 ), ms(i) mlabel(CountryCode) mlabcolor(black) mlabsize(vsmall)) name(total, replace)
	
grc1leg total pc, legendfrom(total)

//FIGURE 6 - Targeted reductions and total emissions
	twoway (scatter rel_reduction_low2 ln_kyoto_start if wbregion==1 & year==2005 & quantobj_kyoto==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low2 ln_kyoto_start if wbregion==2 & year==2005 & quantobj_kyoto==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low2 ln_kyoto_start if wbregion==3 & year==2005 & quantobj_kyoto==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low2 ln_kyoto_start if wbregion==4 & year==2005 & quantobj_kyoto==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low2 ln_kyoto_start if wbregion==5 & year==2005 & quantobj_kyoto==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low2 ln_kyoto_start if wbregion==6 & year==2005 & quantobj_kyoto==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low2 ln_kyoto_start if wbregion==7 & year==2005 & quantobj_kyoto==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ), ytitle("Targeted GHG emission reduction, %") ///
		xtitle("ln(Start year GHG emissions)") name(kyotarget, replace) ///
		legend(order(1 "East Asia/Pacific" 2 "Europe/Central Asia" ///
		3 "Latin America/Caribbean" 4 "Middle East/North Africa" 5 "North America" ///
		6 "South Asia" 7 "Sub-Saharan Africa") size(small) col(3))
		
		twoway (scatter rel_reduction_low1 ln_cope_start if wbregion==1 & year==2012 & quantobj_cope==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low1 ln_cope_start if wbregion==2 & year==2012 & quantobj_cope==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low1 ln_cope_start if wbregion==3 & year==2012 & quantobj_cope==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low1 ln_cope_start if wbregion==4 & year==2012 & quantobj_cope==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low1 ln_cope_start if wbregion==5 & year==2012 & quantobj_cope==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low1 ln_cope_start if wbregion==6 & year==2012 & quantobj_cope==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low1 ln_cope_start if wbregion==7 & year==2012 & quantobj_cope==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) if CountryCode!="LVA" & CountryCode!="SRB", ///
		ytitle("Targeted GHG emission reduction, %") ///
		xtitle("ln(Start year GHG emissions)") name(copetarget, replace) ///
		legend(order(1 "East Asia/Pacific" 2 "Europe/Central Asia" ///
		3 "Latin America/Caribbean" 4 "Middle East/North Africa" 5 "North America" ///
		6 "South Asia" 7 "Sub-Saharan Africa") size(small) col(3))
		
		
		twoway (scatter rel_reduction_low3 ln_paris_start if wbregion==1 & year==2017 & quantobj_par==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low3 ln_paris_start if wbregion==2 & year==2017 & quantobj_par==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low3 ln_paris_start if wbregion==3 & year==2017 & quantobj_par==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low3 ln_paris_start if wbregion==4 & year==2017 & quantobj_par==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low3 ln_paris_start if wbregion==5 & year==2017 & quantobj_par==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low3 ln_paris_start if wbregion==6 & year==2017 & quantobj_par==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) ///
		(scatter rel_reduction_low3 ln_paris_start if wbregion==7 & year==2017 & quantobj_par==1, ///
		mlabel(CountryCode) mlabsize(vsmall) mlabvpos(label_pos70) ) if CountryCode!="KIR" & CountryCode!="LVA" ///
		& CountryCode!="ROU" & CountryCode!="MDG", ytitle("Targeted GHG emission reduction, %") ///
		xtitle("ln(Start year GHG emissions)") name(partarget, replace) ///
		legend(order(1 "East Asia/Pacific" 2 "Europe/Central Asia" ///
		3 "Latin America/Caribbean" 4 "Middle East/North Africa" 5 "North America" ///
		6 "South Asia" 7 "Sub-Saharan Africa") size(small) col(3))
		

//FIGURE 7 - Target achievement Kyoto
twoway (scatter dghg2005_rel rel_reduction_low2 if quantobj_kyoto==1, mlabel(CountryCode) ///
	mlabsize(vsmall) mlabpos(4) xline(0) yline(0) yscale(range(-300 100))) ///
	(function y=x, range(-300 100)), ytitle("% decrease in GHG emissions 2005-2012") ///
	xtitle(Targeted reduction (% of start year GHG emissions)) name(kyoto, replace) legend(off) yscale(range(-300 100)) 
	 
twoway (scatter dghg2005_rel rel_reduction_low2 if quantobj_kyoto==1 & CountryCode!="SWE" & CountryCode!="UKR"  & CountryCode!="LVA"  & CountryCode!="ROU", ///
	mlabel(CountryCode) mlabsize(vsmall) mlabpos(4) xline(0) yline(0)) (function y=x, range(-50 50)), ///
	ytitle("% decrease in GHG emissions 2005-2012") xtitle(Targeted reduction (% of start year GHG emissions)) ///
	 name(kyoto, replace) legend(off) yscale(range(-50 50))

//FIGURE 8 - Target achievement Copenhagen
twoway (scatter d1emissions2010_rel rel_reduction_low1 if quantobj_cope==1 & year==2018 & CountryCode!="SRB" & ///
	CountryCode!="LVA" & CountryCode!="ATG", mlabel(CountryCode) ///
	mlabsize(vsmall) mlabpos(4) xline(0) yline(0)) (function y=x, range(-55 50)), ///
	ytitle(% decrease in fossil CO2 emissions 2010-2018) xtitle(Targeted reduction (% of start year GHG emissions)) ///
	 name(cope, replace) legend(off)
	 
 twoway (scatter d1emissions2010_rel rel_reduction_low1 if quantobj_cope==1 & year==2018 , mlabel(CountryCode) ///
	mlabsize(vsmall) mlabpos(4) xline(0) yline(0)) (function y=x, range(-100 50)), ///
	ytitle(% decrease in fossil CO2 emissions 2010-2018) xtitle(Targeted reduction (% of start year GHG emissions)) ///
	 name(cope, replace) legend(off)

//FIGURE 9 - Checking overlap of propensity scores
twoway (kdensity phat_kyo if signed_kyo==0, lpattern(dash) color(red) lwidth(medthick)) ///
	(kdensity phat_kyo if signed_kyo==1, color(blue) lwidth(thick)), ///
	title("") legend(label(1 "Control dist.") label(2 "Treatment dist.")) ///
	ytitle("Frequency") ///
	xtitle("Estimated probability of treatment") 

twoway (kdensity phat_cop if signed_cope==0, lpattern(dash) color(red) lwidth(medthick)) ///
	(kdensity phat_cop if signed_cope==1, color(blue) lwidth(thick)), ///
	title("") legend(label(1 "Control dist.") label(2 "Treatment dist.")) ///
	ytitle("Frequency") ///
	xtitle("Estimated probability of treatment") 
	
twoway (kdensity phat_par if signed_paris==0, lpattern(dash) color(red) lwidth(medthick)) ///
	(kdensity phat_par if signed_paris==1, color(blue) lwidth(thick)), ///
	title("") legend(label(1 "Control dist.") label(2 "Treatment dist.")) ///
	ytitle("Frequency") ///
	xtitle("Estimated probability of treatment") 

//**********LOCAL PROJECTIONS****************
sort cntry year								
xtset  cntry year, yearly

//Computing IPW

//POLICIES
bysort country: egen carbontax_year1=min(year) if have_carbontax==1
bysort country: egen carbontax_year=mean(carbontax_year1)
drop carbontax_year1
replace carbontax_year=2018 if carbontax_year==. //use latest year for countries that still don't have a tax

bysort country: egen ets_year1=min(year) if have_emissiontrade==1
bysort country: egen ets_year=mean(ets_year1)
drop ets_year1
replace ets_year=2018 if ets_year==. //use latest year for countries that still don't have a tax

//Keeping panel data
xtset cntry year, yearly
probit carbontax l1.lemissions gdppc lpop lurb cpi_inflation 
eststo ct
predict phat_ct
gen w_ct=carbontax/phat_ct+(1-carbontax)*(1/(1-phat_ct))

gen phat_ct1=phat_ct
replace phat_ct1=0.9 if phat_ct>0.9 & phat_ct!=.
replace phat_ct1=0.1 if phat_ct<0.1
gen w_ct1=carbontax/phat_ct1+(1-carbontax)*(1/(1-phat_ct1))

probit ets l1.lemissions gdppc lpop lurb cpi_inflation   
eststo ets
predict phat_ets
gen w_ets=ets/phat_ets+(1-ets)*(1/(1-phat_ets))

gen phat_ets1=phat_ets
replace phat_ets1=0.9 if phat_ets>0.9 & phat_ets!=.
replace phat_ets1=0.1 if phat_ets<0.1
gen w_ets1=ets/phat_ets1+(1-ets)*(1/(1-phat_ets1))


//Pledges
drop phat_kyo phat_kyo1 w1_kyo w2_kyo w_kyo1
xtset cntry year, yearly
probit signed_kyoto l1.lemissions gdppc lpop lurb cpi_inflation   if year==2005
eststo kyo
predict phat_kyo
gen w1_kyo=signed_kyoto/phat_kyo + (1-signed_kyoto)*(1/(1-phat_kyo)) if year==2005
bysort country: egen w_kyo=mean(w1_kyo)

gen phat_kyo1=phat_kyo
replace phat_kyo1=0.9 if phat_kyo>0.9 & phat_kyo!=. & year==2005
replace phat_kyo1=0.1 if phat_kyo<0.1 & year==2005
gen w2_kyo=signed_kyoto/phat_kyo1 + (1-signed_kyoto)*(1/(1-phat_kyo1)) if year==2005
bysort country: egen w_kyo1=mean(w2_kyo)

drop phat_cop phat_cop1 w1_cop  w2_cop w_cop1
xtset cntry year, yearly
probit signed_cope l1.lemissions l1.gdppc l1.lpop l1.lurb l1.cpi_inflation if year==2010
eststo cope
predict phat_cop
gen w1_cop=signed_cope/phat_cop + (1-signed_cope)*(1/(1-phat_cop)) if year==2010
bysort country: egen w_cop=mean(w1_cop)

gen phat_cop1=phat_cop
replace phat_cop1=0.9 if phat_cop>0.9 & phat_cop!=. & year==2010
replace phat_cop1=0.1 if phat_cop<0.1 & year==2010
gen w2_cop=signed_cope/phat_cop1 + (1-signed_cope)*(1/(1-phat_cop1)) if year==2010
bysort country: egen w_cop1=mean(w2_cop)


//APPENDIX E - Checking overlap for propensity scores
twoway (kdensity phat_kyo if signed_kyo==0, lpattern(dash) color(red) lwidth(medthick)) ///
	(kdensity phat_kyo if signed_kyo==1, color(blue) lwidth(thick)), ///
	title("") legend(label(1 "Control dist.") label(2 "Treatment dist.")) ///
	ytitle("Frequency") ///
	xtitle("Estimated probability of treatment") 

twoway (kdensity phat_cop if signed_cope==0, lpattern(dash) color(red) lwidth(medthick)) ///
	(kdensity phat_cop if signed_cope==1, color(blue) lwidth(thick)), ///
	title("") legend(label(1 "Control dist.") label(2 "Treatment dist.")) ///
	ytitle("Frequency") ///
	xtitle("Estimated probability of treatment") 

twoway (kdensity phat_ets if ets==0, lpattern(dash) color(red) lwidth(medthick)) ///
	(kdensity phat_ets if ets==1, color(blue) lwidth(thick)), ///
	title("") legend(label(1 "Control dist.") label(2 "Treatment dist.")) ///
	ytitle("Frequency") ///
	xtitle("Estimated probability of treatment") 

twoway (kdensity phat_ct if carbontax==0, lpattern(dash) color(red) lwidth(medthick)) ///
	(kdensity phat_ct if carbontax==1, color(blue) lwidth(thick)), ///
	title("") legend(label(1 "Control dist.") label(2 "Treatment dist.")) ///
	ytitle("Frequency") ///
	xtitle("Estimated probability of treatment") 


xtset cntry year, yearly

eststo clear
//drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0


forv h = 0/9 {
	gen lemissions1`h' = f`h'.lemissions		// Level
	gen gdp`h' = f`h'.gdp	
	gen dgdp`h' = f`h'.dgdp	
	gen cpi_inflation`h'=f`h'.cpi_inflation
}

//*****************BASELINE EMISSIONS RESULTS**************
xtset cntry year, yearly

eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
reg lemissions1`h' l(1/3)lemissions l(1/3)gdp l(1/3)lpop l(1/3)lurb l(0/3)carbontax i.cntry i.year [pw=w_ct1] , robust
replace b = (exp(_b[carbontax])-1 )*100                    if _n == `h'+2
replace u = (exp(_b[carbontax] + 1.645* _se[carbontax])-1)*100  if _n == `h'+2
replace d = (exp(_b[carbontax] - 1.645* _se[carbontax])-1)*100  if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(carbontax)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of emissions to national level carbon tax", color(black) size(medsmall)) ///
		ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_ct , replace

	
eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
reg lemissions1`h' l(1/3)lemissions l(1/3)gdp l(1/3)lpop l(1/3)lurb l(0/3)ets i.cntry i.year [pw=w_ets1], robust
replace b = (exp(_b[ets])  -1 )*100                    if _n == `h'+2
replace u = (exp(_b[ets] + 1.645* _se[ets])-1 )*100   if _n == `h'+2
replace d = (exp(_b[ets] - 1.645* _se[ets])-1 )*100   if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(ets)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of emissions to national level ETS", color(black) size(medsmall)) ///
		ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_ets , replace

eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
xtreg lemissions1`h' l(1/3)lemissions l(1/3)gdp l(1/3)lpop l(1/3)lurb l(0/3)kyoto i.year [pw=w_kyo1], fe robust
replace b = (exp(_b[kyoto])-1 )*100                      if _n == `h'+2
replace u = (exp(_b[kyoto] + 1.645* _se[kyoto])-1 )*100   if _n == `h'+2
replace d = (exp(_b[kyoto] - 1.645* _se[kyoto])-1 )*100   if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(kyoto)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of emissions to signing KP", color(black) size(medsmall)) ///
		ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_kyoto , replace

eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
xtreg lemissions1`h' l(1/3)lemissions l(1/3)gdp l(1/3)lpop l(1/3)lurb l(0/3)cope i.year [pw=w_cop1], fe robust
replace b = (exp(_b[cope])-1 )*100                      if _n == `h'+2
replace u = (exp(_b[cope] + 1.645* _se[cope])-1 )*100   if _n == `h'+2
replace d = (exp(_b[cope] - 1.645* _se[cope])-1 )*100   if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(cope)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of emissions to signing CA", color(black) size(medsmall)) ///
		ytitle("Percent", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_cope , replace
		
//FIGURE 10 - local projections
graph combine g_kyoto g_cope g_ct g_ets, ycommon xcommon 


//Estimating effect on GDP growth

xtile cpi_pctile=cpi_inflation, nq(100)
xtset cntry year, yearly

eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
reg dgdp`h' l(1/3)dlemissions l(1/3)dgdp l(1/3)dlpop l(1/3)dlurb l(1/3)cpi_inflation l(0/3)carbontax i.cntry i.year##i.wbregion [pw=w_ct1] if cpi_pctile<=93, robust
replace b = (_b[carbontax] )                   if _n == `h'+2
replace u = (_b[carbontax] + 1.645* _se[carbontax])  if _n == `h'+2
replace d = (_b[carbontax] - 1.645* _se[carbontax])  if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(carbontax)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of GDP growth to national level carbon tax", color(black) size(medsmall)) ///
		ytitle("Percentage points", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_ct2 , replace


eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
reg dgdp`h' l(1/3)dlemissions l(1/3)dgdp l(1/3)dlpop l(1/3)dlurb  l(1/3)cpi_inflation  l(0/3)ets i.cntry i.year##i.wbregion [pw=w_ets1] if cpi_pctile<=93, robust
replace b = (_b[ets]    )               if _n == `h'+2
replace u =(_b[ets] + 1.645* _se[ets])   if _n == `h'+2
replace d = (_b[ets] - 1.645* _se[ets] )  if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(ets)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of GDP growth to national level ETS", color(black) size(medsmall)) ///
		ytitle("Percentage points", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_ets2 , replace


eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
xtreg dgdp`h' l(1/3)dlemissions l(1/3)dgdp l(1/3)dlpop l(1/3)dlurb  l(1/3)cpi_inflation  l(0/3)kyoto i.year##i.wbregion [pw=w_kyo1] if cpi_pctile<=93, fe robust
replace b = (_b[kyoto]   )                   if _n == `h'+2
replace u = (_b[kyoto] + 1.645* _se[kyoto])   if _n == `h'+2
replace d = (_b[kyoto] - 1.645* _se[kyoto])   if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(kyoto)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of GDP growth to signing KP", color(black) size(medsmall)) ///
		ytitle("Percentage points", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_kyoto2 , replace

eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
xtreg dgdp`h' l(1/3)dlemissions l(1/3)dgdp l(1/3)dlpop l(1/3)dlurb l(1/3)cpi_inflation   l(0/3)cope i.year##i.wbregion [pw=w_cop1] if cpi_pctile<=93, fe robust
replace b = (_b[cope])                      if _n == `h'+2
replace u = (_b[cope] + 1.645* _se[cope] )  if _n == `h'+2
replace d = (_b[cope] - 1.645* _se[cope])   if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(cope)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of GDP growth to signing CA", color(black) size(medsmall)) ///
		ytitle("Percentage points", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_cope2 , replace

//FIGURE 11 - GDP growth
graph combine g_kyoto2 g_cope2 g_ct2 g_ets2, ycommon xcommon 

//Estimating effect on inflation
xtset cntry year, yearly

eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
reg cpi_inflation`h' l(1/3)dlemissions l(1/3)dgdp l(1/3)dlpop l(1/3)dlurb l(1/3)cpi_inflation   l(0/3)carbontax i.cntry i.year##i.wbregion [pw=w_ct1] if cpi_pctile<=93, robust
replace b = (_b[carbontax] )                  if _n == `h'+2
replace u = (_b[carbontax] + 1.645* _se[carbontax])  if _n == `h'+2
replace d = (_b[carbontax] - 1.645* _se[carbontax])  if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(carbontax)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of inflation to national level carbon tax", color(black) size(medsmall)) ///
		ytitle("Percentage points", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_ct2 , replace


	
eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
reg cpi_inflation`h' l(1/3)dlemissions l(1/3)dgdp l(1/3)dlpop l(1/3)dlurb  l(1/3)cpi_inflation  l(0/3)ets i.cntry i.year##i.wbregion [pw=w_ets1] if cpi_pctile<=93, robust
replace b = (_b[ets]  )                 if _n == `h'+2
replace u = (_b[ets] + 1.645* _se[ets])   if _n == `h'+2
replace d = (_b[ets] - 1.645* _se[ets] )  if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(ets)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of inflation to national level ETS", color(black) size(medsmall)) ///
		ytitle("Percentage points", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_ets2 , replace


eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
xtreg cpi_inflation`h' l(1/3)dlemissions l(1/3)dgdp l(1/3)dlpop l(1/3)dlurb  l(1/3)cpi_inflation  l(0/3)kyoto i.year##i.wbregion [pw=w_kyo1] if cpi_pctile<=93, fe robust
replace b = (_b[kyoto] )                     if _n == `h'+2
replace u = (_b[kyoto] + 1.645* _se[kyoto])   if _n == `h'+2
replace d = (_b[kyoto] - 1.645* _se[kyoto])   if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(kyoto)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of inflation to signing KP", color(black) size(medsmall)) ///
		ytitle("Percentage points", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_kyoto2 , replace

eststo clear
drop b u d Years Zero
gen Years = _n-1 if _n<=9
gen Zero =  0    if _n<=9
gen b=0
gen u=0
gen d=0

qui forv h = 0/7 {
xtreg cpi_inflation`h' l(1/3)dlemissions l(1/3)dgdp l(1/3)dlpop l(1/3)dlurb l(1/3)cpi_inflation   l(0/3)cope i.year##i.wbregion [pw=w_cop1] if cpi_pctile<=93, fe robust
replace b = (_b[cope] )                     if _n == `h'+2
replace u = (_b[cope] + 1.645* _se[cope])  if _n == `h'+2
replace d = (_b[cope] - 1.645* _se[cope])  if _n == `h'+2
eststo 
}
nois esttab , se nocons keep(cope)

twoway ///
		(rarea u d  Years,  ///
		fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
		(line b Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line Zero Years, lcolor(black)), legend(off) ///
		title("Response of inflation to signing CA", color(black) size(medsmall)) ///
		ytitle("Percentage points", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white))
		
		gr rename g_cope2 , replace

//FIGURE 12 - Inflation
graph combine g_kyoto2 g_cope2 g_ct2 g_ets2, ycommon xcommon 














