drop _all
set memory 600000
set matsize 4000
set maxvar 20000
use EUKLEMS, clear
keep country code desc Year Goods YYDif XXDif QDif
sort country Year
merge country Year using EUInstruments
tab _m
drop if _m == 2
drop _m
save aa, replace

***********************************************************************

*Table II:  No instrument is 1st stage significant
matrix R = J(4,2,0)
local c = 0
foreach m in lnMExpDifSIPRI lnMetalsPriceDif lnOilPriceDif SW2 {
	local c = `c' + 1
	use aa, clear
	drop if `m' == .
	drop if lnURateDifFRED == .
	drop if YYDif == .
	drop if XXDif == .
	egen m = group(code country)
	quietly tab m, gen(I)
	global k = r(r)
	egen mm = group(country Year)
	quietly tab mm, gen(Y)
	global kk = r(r) 
	foreach j in `m' lnURateDifFRED {
		forvalues i = 19/$k {
			quietly generate `j'I`i' = I`i'*`j'
			}
		}
	quietly regress XXDif I19-I$k Y2-Y$kk lnURateDifFREDI* `m'I*
	quietly testparm `m'I*
	matrix R[`c',1] = r(p), e(N)
	}
matrix list R

***************************************************************************

*Table IV:  Defense expenditures by country

*1st stage regressions

use aa, clear
quietly drop if lnMExpDifSIPRI == .
quietly drop if lnURateDifFRED == .
quietly drop if YYDif == .
quietly drop if XXDif == .
sort country code Year
forvalues i = 1/4 {
	quietly generate double L`i'XXDif = XXDif[_n-`i'] if country == country[_n-`i'] & code == code[_n-`i'] & Year == Year[_n-`i'] + `i'
	}
egen Industry = group(code)
tab country, gen(C)
save aaa, replace

matrix R = J(17,1,0)
forvalues c = 1/17 {
	use aaa, clear
	quietly keep if C`c' == 1
	egen m = group(code country)
	quietly tab m, gen(I)
	global k = r(r)
	egen mm = group(country Year)
	quietly tab mm, gen(Y)
	global kk = r(r) 
	foreach j in lnMExpDifSIPRI lnURateDifFRED {
		forvalues i = 1/$k {
			quietly generate `j'I`i' = I`i'*`j'
			}
		}
	quietly regress XXDif I1-I$k Y2-Y$kk lnURateDifFREDI* lnMExpDifSIPRII*
	quietly testparm lnMExpDifSIPRII* 
	matrix R[`c',1] = r(p)
	}
matrix list R

*2nd stage regressions for 1st stage significant

matrix R = J(4,5,0)
matrix RR = J(4,5,0)
local cc = 0
foreach c in 1 7 14 17 {
	local cc = `cc' + 1
	use aaa, clear
	quietly keep if C`c' == 1
	egen m = group(code country)
	quietly tab m, gen(I)
	global k = r(r)
	egen mm = group(country Year)
	quietly tab mm, gen(Y)
	global kk = r(r) 
	foreach j in lnMExpDifSIPRI lnURateDifFRED {
		forvalues i = 1/$k {
			quietly generate `j'I`i' = I`i'*`j'
			}
		}
	quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifFREDI2-lnURateDifFREDI$k lnMExpDifSIPRII2-lnMExpDifSIPRII$k
	quietly testparm lnMExpDifSIPRII* 
	matrix R[`cc',1] = r(p)
	quietly ivregress 2sls YYDif I1-I$k Y2-Y$kk lnURateDifFREDI2-lnURateDifFREDI$k (XXDif = lnMExpDifSIPRII2-lnMExpDifSIPRII$k)
	matrix B = e(b)
	matrix V = e(V)
	quietly estat overid
	matrix R[`cc',2] = r(p_basmann), B[1,1], sqrt(V[1,1]), e(N)

	quietly regress XXDif L1XXDif-L4XXDif I1-I$k Y2-Y$kk lnURateDifFREDI* lnMExpDifSIPRII*
	quietly testparm lnMExpDifSIPRII* 
	matrix RR[`cc',1] = r(p)
	quietly ivregress 2sls YYDif L1XXDif-L4XXDif I1-I$k Y2-Y$kk lnURateDifFREDI* (XXDif = lnMExpDifSIPRII*)
	matrix B = e(b)
	matrix V = e(V)
	quietly estat overid
	matrix C = B[1,1..5]*J(5,1,1)
	matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
	matrix RR[`cc',2] = r(p_basmann), C[1,1], sqrt(CC[1,1]), e(N)
	}
matrix list R
matrix list RR

*Dropping one industry at a time

foreach c in 1 7 14 17 {
	matrix R = J(29,4,0)
	forvalues i = 1/29 {
		use aaa, clear
		quietly keep if C`c' == 1
		quietly drop if Industry == `i'
		egen m = group(code country)
		quietly tab m, gen(I)
		global k = r(r)
		egen mm = group(country Year)
		quietly tab mm, gen(Y)
		global kk = r(r) 
		foreach j in lnMExpDifSIPRI lnURateDifFRED {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = I`k'*`j'
				}
			}
		quietly regress XXDif I1-I$k Y2-Y$kk lnURateDifFREDI2-lnURateDifFREDI$k lnMExpDifSIPRII2-lnMExpDifSIPRII$k
		quietly testparm lnMExpDifSIPRII* 
		matrix R[`i',1] = r(p)
		quietly ivregress 2sls YYDif I1-I$k Y2-Y$kk lnURateDifFREDI2-lnURateDifFREDI$k (XXDif = lnMExpDifSIPRII2-lnMExpDifSIPRII$k)
		matrix B = e(b)
		matrix V = e(V)
		quietly estat overid
		matrix R[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1])
		}
	drop _all
	svmat double R
	save R`c', replace
	sum
	sort R3
	list if _n == 1
	list if _n == _N
	}


******************************************************

*Table VII:  OLS by country
use aa, clear
quietly drop if lnURateDifFRED == .
quietly drop if YYDif == .
quietly drop if XXDif == .
sort country code Year
forvalues i = 1/4 {
	quietly generate double L`i'XXDif = XXDif[_n-`i'] if country == country[_n-`i'] & code == code[_n-`i'] & Year == Year[_n-`i'] + `i'
	}
tab country, gen(C)
save aaa, replace

matrix R = J(4,6,0)
local cc = 0
foreach c in 1 7 14 17 {
	local cc = `cc' + 1
	use aaa, clear
	quietly keep if C`c' == 1
	egen m = group(code)
	quietly tab m, gen(I)
	global k = r(r)
	egen mm = group(Year)
	quietly tab mm, gen(Y)
	global kk = r(r) 
	forvalues i = 1/$k {
		quietly generate lnURateDifFREDI`i' = I`i'*lnURateDifFRED
		}
	quietly regress YYDif XXDif I2-I$k Y2-Y$kk lnURateDifFREDI2-lnURateDifFREDI$k 
	matrix B = e(b)
	matrix V = e(V)
	matrix R[`cc',1] = B[1,1], sqrt(V[1,1]), e(N) 

	quietly regress YYDif XXDif L1XXDif-L4XXDif I1-I$k Y2-Y$kk lnURateDifFREDI2-lnURateDifFREDI$k 
	matrix B = e(b)
	matrix V = e(V)
	matrix C = B[1,1..5]*J(5,1,1)
	matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
	matrix R[`cc',4] = C[1,1], sqrt(CC[1,1]), e(N)
	}
matrix list R

*Entire data set

matrix R = J(2,3,0)
use aa, clear
quietly drop if lnURateDifFRED == .
quietly drop if YYDif == .
quietly drop if XXDif == .
sort country code Year
egen m = group(code country)
quietly tab m, gen(I)
global k = r(r)
egen mm = group(country Year)
quietly tab mm, gen(Y)
global kk = r(r) 
forvalues i = 1/4 {
	quietly generate double L`i'XXDif = XXDif[_n-`i'] if country == country[_n-`i'] & code == code[_n-`i'] & Year == Year[_n-`i'] + `i'
	}
forvalues i = 19/$k {
	quietly generate lnURateDifFREDI`i' = I`i'*lnURateDifFRED
	}
quietly regress YYDif XXDif I19-I$k Y2-Y$kk lnURateDifFREDI19-lnURateDifFREDI$k 
matrix B = e(b)
matrix V = e(V)
matrix R[1,1] = B[1,1], sqrt(V[1,1]), e(N)
quietly regress YYDif XXDif L1XXDif-L4XXDif I19-I$k Y2-Y$kk lnURateDifFREDI19-lnURateDifFREDI$k 
matrix B = e(b)
matrix V = e(V)
matrix C = B[1,1..5]*J(5,1,1)
matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
matrix R[2,1] = C[1,1], sqrt(CC[1,1]), e(N)
matrix list R


*******************************************************

*Text/Footnotes:  Data Issues - negative capital income shares
use EUKLEMS, clear
replace country = "USASIC" if country == "USA"
append using USNAICSEUKLEMS
sort country code Year
generate t = CAP/VA
generate tt = CAP/GO
sum t tt if TFPGO ~= .
sum t tt if t < 0 & TFPGO ~= .
foreach j in LAB CAP II {
	replace `j' = `j'/GO
	generate `j'bar = (`j' + `j'[_n-1])/2 if country == country[_n-1] & code == code[_n-1] & Year == Year[_n-1] + 1
	}
generate tfpg = ln(GO_QI/GO_QI[_n-1]) - LABbar*ln(LAB_QI/LAB_QI[_n-1]) - CAPbar*ln(CAP_QI/CAP_QI[_n-1]) - IIbar*ln(II_QI/II_QI[_n-1]) if country == country[_n-1] & code == code[_n-1] & Year == Year[_n-1] + 1
generate tfpg2 = ln(GO_QI/GO_QI[_n-1]) - LABbar*ln(LAB_QI/LAB_QI[_n-1]) - IIbar*ln(II_QI/II_QI[_n-1]) if country == country[_n-1] & code == code[_n-1] & Year == Year[_n-1] + 1
regress YYDif tfpg if t < 0
regress YYDif tfpg2 if t < 0
tab country if t < 0 & TFPGO ~= .
display r(r)

*********************************************************

*Table VIII:  Goods, services & total private sector TFP growth under various elasticity scenarios

matrix R = J(5,3,0)
forvalues i = 0/4 {
	global e = `i'*.25
	use EUKLEMS, clear
	quietly drop if TFPGO == .
	sort country code Year
	quietly replace VA = LAB + CAP
	egen double m = sum(VA), by(country Goods Year)
	egen double mm = sum(VA), by(country Year)
	quietly replace m = GO/m
	quietly replace mm = VA/mm
	quietly generate double mbar = (m + m[_n-1])/2 if country == country[_n-1] & code == code[_n-1] & Year == Year[_n-1] + 1
	quietly generate double mmbar = (mm + mm[_n-1])/2 if country == country[_n-1] & code == code[_n-1] & Year == Year[_n-1] + 1
	quietly generate double tfpg = (YYDif + $e*XXDif)*mbar
	quietly drop if tfpg == .
	collapse (sum) tfpg mmbar, by(country Goods Year) fast
	quietly sum tfpg if Goods == 1
	matrix R[`i'+1,1] = r(mean)
	quietly sum tfpg if Goods == 0
	matrix R[`i'+1,2] = r(mean)
	quietly replace tfpg = tfpg*mmbar
	quietly collapse (sum) tfpg mmbar, by(country Year) fast
	quietly sum tfpg
	matrix R[`i'+1,3] = r(mean)
	}
matrix list R

*Text on growth of relative output and prices

use EUKLEMS, clear
tab country code if VA ~= . & VA_QI == .
tab Year if country == "PRT" & VA_QI ~= .
*Portugal often, but not always, missing code == "23" VA_QI
drop if country == "PRT" & code == "23"
drop if VA_QI == .
sum VA VA_QI VA_PI
egen M = sum(VA), by(country Goods Year) 
replace VA = VA/M
sort country code Year
generate qi = ln(VA_QI/VA_QI[_n-1])*(VA+VA[_n-1])/2 if country == country[_n-1] & code == code[_n-1] & Year == Year[_n-1] + 1
generate pi = ln(VA_PI/VA_PI[_n-1])*(VA+VA[_n-1])/2 if country == country[_n-1] & code == code[_n-1] & Year == Year[_n-1] + 1
tab country if qi == .
collapse (sum) qi pi, by(country Goods Year) fast
collapse (mean) qi pi, by(Goods) fast
generate QDif = qi - qi[_n+1]
generate PDif = pi - pi[_n+1]
list

*Footnote on relative wages & factor shares

use EUKLEMS, clear
drop if TFPGO == .
sum LAB VA HEMP Goods if VA ~= 0
sum LAB VA HEMP Goods if VA == 0
collapse (sum) LAB VA HEMP, by(country Goods Year)
generate Theta = LAB/VA
generate Wage = LAB/HEMP
sort country Year Goods
generate WDif = ln(Wage/Wage[_n-1]) if Goods == 1 & Goods[_n-1] == 0
generate TDif = ln(Theta/Theta[_n-1]) if Goods == 1 & Goods[_n-1] == 0
sort Goods country Year
by Goods: sum Theta WDif
areg WDif Year, absorb(country)
areg TDif Year, absorb(country)










