*Table V

*Prepare data

drop _all
clear mata
set memory 300000
set matsize 2000
use USNAICSEUKLEMS, clear
sort Year
merge Year using Instruments
tab _m
drop if _m == 2
drop _m
drop if YYDif == .
drop if XXDif == .
egen Industry = group(code)
save aa, replace

*1st stage p-values

use aa, clear
quietly tab Industry, gen(I)
global k = r(r)
foreach j in lnURateDif lnMExpDif lnMetalsPriceDif lnOilPriceDif SW1 SW2 SW3 SW4 SW5 SW6 SW7 SW8 SW9 SW10 SW11 SW12 SW13 SW14 SW15 {
	forvalues k = 1/$k {
		quietly generate `j'I`k' = `j'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)
matrix R = J(18,1,0)
local k = 0
foreach j in lnMExpDif lnMetalsPriceDif lnOilPriceDif SW1 SW2 SW3 SW4 SW5 SW6 SW7 SW8 SW9 SW10 SW11 SW12 SW13 SW14 SW15 {
	local k = `k' + 1
	quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `j'I2-`j'I$k
	quietly testparm `j'*
	matrix R[`k',1] = r(p)
	}
matrix list R

*Horserace Ramey vs. Defense Expenditures
quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k lnMExpDifI2-lnMExpDifI$k SW13I2-SW13I$k
testparm SW13I*
testparm lnMExpDifI*


*Panel A: Baseline

matrix R = J(6,4,0)
local i = 0
foreach m in lnMExpDif lnOilPriceDif SW1 SW5 SW6 SW10 {
		local i = `i' + 1
		use aa, clear
		quietly drop if `m' == .
		quietly tab Industry, gen(I)
		global k = r(r)
		foreach j in lnURateDif `m' {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = `j'*I`k'
				}
			}
		quietly tab Year, gen(Y)
		global kk = r(r)
		quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `m'I2-`m'I$k
		quietly testparm `m'*
		matrix R[`i',1] = r(p)
		quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = `m'I2-`m'I$k)
		matrix B = e(b)
		matrix V = e(V)
		quietly estat overid
		matrix R[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1])
	}
matrix list R


*Panel C:  Lags

matrix RR = J(6,4,0)
local i = 0
foreach m in lnMExpDif lnOilPriceDif SW1 SW5 SW6 SW10 {
	local i = `i' + 1
	use aa, clear
	quietly drop if `m' == .
	sort Industry Year
	forvalues c = 1/4 {
		generate L`c'XXDif = XXDif[_n-`c'] if Industry == Industry[_n-`c'] & Year == Year[_n-`c'] + `c'
		}
	quietly tab Industry, gen(I)
	global k = r(r)
	foreach j in lnURateDif `m' {
		forvalues k = 1/$k {
			quietly generate `j'I`k' = `j'*I`k'
			}
		}
	quietly tab Year, gen(Y)
	global kk = r(r)
	quietly regress XXDif L1XXDif-L4XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `m'I2-`m'I$k 
	quietly testparm `m'I*
	matrix RR[`i',1] = r(p)
	quietly ivregress 2sls YYDif L1XXDif-L4XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = `m'I2-`m'I$k)
	quietly estat overid
	matrix B = e(b)
	matrix V = e(V)
	matrix C = B[1,1..5]*J(5,1,1)
	matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
	matrix CCC = C[1,1], sqrt(CC[1,1])
	matrix RR[`i',2] = r(p_basmann), CCC
	}
matrix list RR


*Panel B:  Dropping one industry at a time

foreach m in lnMExpDif lnOilPriceDif SW1 SW5 SW6 SW10 {
	matrix R = J(29,4,0)
	forvalues i = 1/29 {
		use aa, clear
		quietly drop if `m' == .
		quietly drop if Industry == `i'
		quietly tab Industry, gen(I)
		global k = r(r)
		foreach j in lnURateDif `m' {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = `j'*I`k'
				}
			}
		quietly tab Year, gen(Y)
		global kk = r(r)
		quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `m'I2-`m'I$k
		quietly testparm `m'*
		matrix R[`i',1] = r(p)
		quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = `m'I2-`m'I$k)
		matrix B = e(b)
		matrix V = e(V)
		quietly estat overid
		matrix R[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1])
		}
	drop _all
	svmat double R
	save USNAICSR`m', replace
	sum
	sort R3
	list if _n == 1
	list if _n == _N
	}


*Table VII OLS
matrix R = J(2,3,0)
use aa, clear
sort Industry Year
forvalues c = 1/4 {
	generate L`c'XXDif = XXDif[_n-`c'] if Industry == Industry[_n-`c'] & Year == Year[_n-`c'] + `c'
	}
quietly tab Industry, gen(I)
global k = r(r)
forvalues k = 1/$k {
	quietly generate lnURateDifI`k' = lnURateDif*I`k'
	}
quietly tab Year, gen(Y)
global kk = r(r)
quietly regress YYDif XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
matrix B = e(b)
matrix V = e(V)
matrix R[1,1] = B[1,1], sqrt(V[1,1]), e(N)
quietly regress YYDif XXDif L1XXDif-L4XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
matrix B = e(b)
matrix V = e(V)
matrix C = B[1,1..5]*J(5,1,1)
matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
matrix R[2,1] = C[1,1], sqrt(CC[1,1]), e(N)
matrix list R



















