
set more 1
clear matrix
clear
set mem 700m

use Lei_Michaels_JDE_2014_data.dta, clear

*rm tables.smcl
*log using tables

*******************************
* Table 1: summary statistics *
*******************************
su discovery a_75_disc a_50_b_75_disc a_25_b_50_disc b_25_disc onshore offshore discovery_databook wildcat d_wildcat newdis_05 a_d_new_discovery ln_oil_gas_value_2005_ppp_pc ln_oil_export_2005usd_pc ln_nonoil_export_2005usd_pc war_type_3_location war_type_3_int_location war_type_3_4_location war_location coup repression polity2 ethnic ln_real_xrat ln_debt ln_rgdppc_2005dollar ln_rgdppcg_2005dollar ln_rgdppcc_2005dollar ln_rgdppci_2005dollar milex_pc_ppp milex_gdp_ppp if year>=1946
foreach var of varlist discovery a_75_disc a_50_b_75_disc a_25_b_50_disc b_25_disc onshore offshore discovery_databook wildcat d_wildcat newdis_05 a_d_new_discovery ln_oil_gas_value_2005_ppp_pc ln_oil_export_2005usd_pc ln_nonoil_export_2005usd_pc war_type_3_location war_type_3_int_location war_type_3_4_location war_location coup repression polity2 ethnic ln_real_xrat ln_debt ln_rgdppc_2005dollar ln_rgdppcg_2005dollar ln_rgdppcc_2005dollar ln_rgdppci_2005dollar milex_pc_ppp milex_gdp_ppp{
egen `var'_max = max(year) if `var'!=. & year>=1946
egen `var'_min = min(year) if `var'!=. & year>=1946
}
su  discovery_max-milex_gdp_ppp_min if year>=1946
tab country discovery if year>=1946


****************************************************************
* Table 2: effect of oil discoveries on oil output, oil export *
****************************************************************




* effect of oil discoveries on log oil (and gas) production per capita
rename ln_oil_gas_value_2005_ppp_pc ln_oil_value_2005_ppp_pc
set more 1
sort key year
tsset key year
foreach var of varlist ln_oil_value_2005_ppp_pc  {
 foreach num of numlist 2(2)10 {
  by key : gen led`num'`var' = f`num'.`var'
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}


* effect of oil discoveries on log oil (and gas) exports per capita

set more 1
sort key year
tsset key year
foreach var of varlist ln_oil_export_2005usd_pc  {
 foreach num of numlist 2(2)10 {
  by key : gen led`num'`var' = f`num'.`var'
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

*******************************************************
* Table 3: effect of oil discoveries on internal wars *
*******************************************************

* effect of oil discoveries on internal wars 

set more 1
foreach var of varlist war_type_3_location {
 foreach num of numlist 2(2)10 {
  by key : gen led`num'`var' = f`num'.`var'
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on scaled intensity of internal wars 


set more 1
foreach var of varlist war_type_3_int_location {
 foreach num of numlist 2(2)10 {
  by key : gen led`num'`var' = f`num'.`var'
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on internal and internationalized internal wars

set more 1
foreach var of varlist war_type_3_4_location {
 foreach num of numlist 2(2)10 {
  by key : gen led`num'`var' = f`num'.`var'
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

*************************************************************************************
*Table 4: Heterogeneous Effecst of Giant Oil Discoveries on Internal Armed Conflicts*
*************************************************************************************

* effect of oil discoveries on internal wars for countries that had at least one coup in previous 10 years 
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_coups_previous_10_years>0 & m_coups_previous_10_years!=., a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & m_coups_previous_10_years>0 & m_coups_previous_10_years!=., a(country) cluster(key)
 }
}

* effect of oil discoveries on internal wars for countries that had no coups in previous 10 years 

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_coups_previous_10_years==0, a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & m_coups_previous_10_years==0, a(country) cluster(key)
 }
}

* effect of oil discoveries on internal wars for countries that had at least internal war in previous 10 years 

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
}

* effect of oil discoveries on internal wars for countries that had no internal wars in previous 10 years 

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years==0, a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years==0, a(country) cluster(key)
 }
}

**************************************************************************
*Table 5: Robustness of Effect of Giant Oil Discoveries on Oil Production*					
**************************************************************************


set more 1
sort key year
tsset key year
foreach var of varlist ln_oil_value_2005_ppp_pc  {
foreach num of numlist 1 2 {
  by key : gen lag`num'`var' = l`num'.`var'
 }
}

sort key year
tsset key year
foreach num of numlist 1 {
foreach var of varlist polity2 ln_rgdppci_2005dollar {
  by key : gen lag`num'`var' = l`num'.`var'
 }
}

* effect of oil discoveries on log oil output per capita controlling for discoveries in past 10 years  
set more 1
foreach var of varlist ln_oil_value_2005_ppp_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}


* effect of oil discoveries on log oil output per capita controlling for discoveries in past 10 years and lagged dependent variable (instrumented)
set more 1
foreach var of varlist ln_oil_value_2005_ppp_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}


* effect of oil discoveries on log oil output per capita controlling for discoveries in past 10 years and lagged polity2 score
set more 1
foreach var of varlist ln_oil_value_2005_ppp_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years lag1polity2 _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on log oil output per capita controlling for discoveries in past 10 years and lagged log investment GDP per capita
set more 1
foreach var of varlist ln_oil_value_2005_ppp_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years lag1ln_rgdppci_2005dollar _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on log oil output per capita controlling for discoveries in past 10 years and all controls
set more 1
foreach var of varlist ln_oil_value_2005_ppp_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}


* effect of oil discoveries on log oil output per capita where oil has not been discovered in past 10 years  
set more 1
foreach var of varlist ln_oil_value_2005_ppp_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 &  t_discovery_previous_10_years==0, a(country) cluster(key)
 }
}


* effect of oil discoveries on log oil output per capita controlling for discoveries in past 10 years for those that ever discover 
set more 1
foreach var of varlist ln_oil_value_2005_ppp_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & any_oil==1, a(country) cluster(key)
 }
}

* effect of oil discoveries on log oil output per capita controlling for discoveries in past 10 years for country*year pairs mentioned as having at least one discovery in the 2004 oil and gas journal databook  
set more 1
foreach var of varlist ln_oil_value_2005_ppp_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & discovery_databook==1, a(country) cluster(key)
 }
}


*********************************************************************
* Table 6: robustness of effect of oil discoveries on internal wars *
*********************************************************************

* effect of oil discoveries on internal wars controlling for discoveries in past 10 years  
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}


* effect of oil discoveries on internal wars controlling for discoveries in past 10 years and lagged dependent variable (instrumented)
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}


* effect of oil discoveries on internal wars controlling for discoveries in past 10 years and lagged polity2 score
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years lag1polity2 _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on internal wars controlling for discoveries in past 10 years and lagged log investment GDP per capita
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years lag1ln_rgdppci_2005dollar _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on internal wars controlling for discoveries in past 10 years and all controls
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}


* effect of oil discoveries on internal wars where oil has not been discovered in past 10 years  
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 &  t_discovery_previous_10_years==0, a(country) cluster(key)
 }
}


* effect of oil discoveries on internal wars controlling for discoveries in past 10 years for those that ever discover 
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & any_oil==1, a(country) cluster(key)
 }
}

* effect of oil discoveries on internal wars controlling for discoveries in past 10 years for country*year pairs mentioned as having at least one discovery in the 2004 oil and gas journal databook  
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & discovery_databook==1, a(country) cluster(key)
 }
}


*************************************************************************************************************************************
* Table 7: robustness of effect of oil discoveries on internal wars in countries that had 1 or more wars in decade before discovery *
*************************************************************************************************************************************

* effect of oil discoveries on internal wars controlling for discoveries in past 10 years  
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
}


* effect of oil discoveries on internal wars controlling for discoveries in past 10 years and lagged dependent variable (instrumented)
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., fe cluster(key)
 }
}


* effect of oil discoveries on internal wars controlling for discoveries in past 10 years and lagged polity2 score
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years lag1polity2 _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
}

* effect of oil discoveries on internal wars controlling for discoveries in past 10 years and lagged log investment GDP per capita
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years lag1ln_rgdppci_2005dollar _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
}

* effect of oil discoveries on internal wars controlling for discoveries in past 10 years and all controls
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., fe cluster(key)
 }
}


* effect of oil discoveries on internal wars where oil has not been discovered in past 10 years  
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 &  t_discovery_previous_10_years==0 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
}


* effect of oil discoveries on internal wars controlling for discoveries in past 10 years for those that ever discover 
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & any_oil==1 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
}

* effect of oil discoveries on internal wars controlling for discoveries in past 10 years for country*year pairs mentioned as having at least one discovery in the 2004 oil and gas journal databook  
set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & discovery_databook==1 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
}

**********************************************************************************
*Table 8: effect of oil discoveries with interactions on internal armed conflicts*
**********************************************************************************
sort key year
tsset key year
foreach num of numlist 1 {
foreach var of varlist ln_rgdppc_2005dollar {
  by key : gen lag`num'`var' = l`num'.`var'
 }
}

gen interaction1=t_war_type_3_previous_10_years*discovery
gen interaction2=lag1ln_rgdppc_2005dollar*discovery
gen interaction3=strong*discovery
gen interaction4=ethnic*discovery

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_war_type_3_previous_10_years interaction1 t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_war_type_3_previous_10_years lag1ln_rgdppc_2005dollar interaction1 interaction2 interaction3 interaction4 t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

*******************************************************************************************************************************************
*Table 9: Effect of Giant Oil Discoveries on PPP-adjusted Per Capita GDP, Government Spending, Private Consumption, and Private Investment*				
*******************************************************************************************************************************************
drop lag1ln_rgdppc*_2005dollar lag1polity2
sort key year
tsset key year
foreach num of numlist 1 2 {
foreach var of varlist ln_rgdppc_2005dollar ln_rgdppcg_2005dollar ln_rgdppcc_2005dollar ln_rgdppci_2005dollar polity2 {
  by key : gen lag`num'`var' = l`num'.`var'
 }
}

sort key year
tsset key year
foreach num of numlist 2(2)10 {
foreach var of varlist ln_rgdppc_2005dollar ln_rgdppcg_2005dollar ln_rgdppcc_2005dollar ln_rgdppci_2005dollar {
  by key : gen led`num'`var' = f`num'.`var'
 }
}

* effect of oil discoveries on ppp-adjusted per capita GDP 
set more 1
foreach var of varlist ln_rgdppc_2005dollar {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on ppp-adjusted per capita GDP with all controls
set more 1
foreach var of varlist ln_rgdppc_2005dollar {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar  _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}

* effect of oil discoveries on ppp-adjusted per capita government spending 
set more 1
foreach var of varlist ln_rgdppcg_2005dollar {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on ppp-adjusted per capita government spending with all controls
set more 1
foreach var of varlist ln_rgdppcg_2005dollar {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar  _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}

* effect of oil discoveries on ppp-adjusted per capita private consumption 
set more 1
foreach var of varlist ln_rgdppcc_2005dollar {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on ppp-adjusted per capita private consumption with all controls
set more 1
foreach var of varlist ln_rgdppcc_2005dollar {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar  _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}

* effect of oil discoveries on ppp-adjusted per capita private investment
set more 1
foreach var of varlist ln_rgdppci_2005dollar {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on ppp-adjusted per capita private investment with all controls
set more 1
foreach var of varlist ln_rgdppci_2005dollar {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar  _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}


*************************************************************
*Table 10: Effect of Giant Oil Discoveries on Other Outcomes*					
*************************************************************

ren ln_nonoil_export_2005usd_pc ln_noil_ex_2005usd_pc
sort key year
tsset key year
foreach num of numlist 1 2 {
foreach var of varlist repression ln_noil_ex_2005usd_pc ln_debt ln_real_xrat {
  by key : gen lag`num'`var' = l`num'.`var'
 }
}

sort key year
tsset key year
foreach num of numlist 2(2)10 {
foreach var of varlist coup repression ln_noil_ex_2005usd_pc ln_debt polity2 ln_real_xrat {
  by key : gen led`num'`var' = f`num'.`var'
 }
}


* effect of oil discoveries on real exchange rate
set more 1
foreach var of varlist ln_real_xrat {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on real exchange rate with all controls
set more 1
foreach var of varlist ln_real_xrat {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}

* effect of oil discoveries on per capita nonoil export
set more 1
foreach var of varlist ln_noil_ex_2005usd_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on per capita nonoil export with all controls
set more 1
foreach var of varlist ln_noil_ex_2005usd_pc {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar  _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}

* effect of oil discoveries on public debt (as a precentage of GDP)
set more 1
foreach var of varlist ln_debt {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on public debt (as precentage of GDP) with all controls
set more 1
foreach var of varlist ln_debt {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar  _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}

* effect of oil discoveries on coup
set more 1
foreach var of varlist coup {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on coup with all controls
set more 1
foreach var of varlist  coup {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar  _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}

* effect of oil discoveries on repression
set more 1
foreach var of varlist repression {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

* effect of oil discoveries on repression with all controls
set more 1
foreach var of varlist repression {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  xtivreg2 `lagnum'`var' discovery t_discovery_previous_10_years (lag1`var'=lag2`var') lag1polity2 lag1ln_rgdppci_2005dollar _Iyear_1947- _Iyear_2008 if year>=1946, fe cluster(key)
 }
}


******************************************************************************************************
* Table A1: Number of years (from 1946-2003) with one or more giant oilfield discoveries, by country *
******************************************************************************************************

tab country discovery if year>=1946


****************************************************************************
* Table A2: Oil Explorations During Lull Period of Internal Armed Conflict *
****************************************************************************
 
set more 1
foreach num of numlist 1(1)5 {
 areg wildcat lull`num' _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
foreach num of numlist 1(1)5 {
 areg d_wildcat lull`num' _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 foreach num of numlist 1(1)5 {
 areg wildcat a_lull`num' _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
foreach num of numlist 1(1)5 {
 areg d_wildcat a_lull`num' _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
********************************************************************************************
* Table A3: Effect of Giant Discoveries on Conflicts: Reconcile with Cotet and Tsui (2013) *
********************************************************************************************
replace wildcat = wildcat / 1000 //This is done to increase readibilty.

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery  _Iyear_1947- _Iyear_2008 if year>=1946 & wildcat!= . , a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & wildcat!= . , a(country) cluster(key)
 }
}

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery wildcat _Iyear_1947- _Iyear_2008 if year>=1946  , a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' discovery wildcat t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 , a(country) cluster(key)
 }
}

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' newdis_05 wildcat _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
  foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' newdis_05 wildcat t_newdis_05_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' newdis_05 a_d_new_discovery wildcat _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
  foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' newdis_05 a_d_new_discovery wildcat t_newdis_05_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}
*************************************************************************
* Table A4: Effect of Oil Discovery in Size on Internal Armed Conflicts * 
*************************************************************************
set more 1
foreach var of varlist war_type_3_location {
foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' a_75_disc a_50_b_75_disc a_25_b_50_disc b_25_disc _Iyear_1947- _Iyear_2008 if year>=1946 , a(country) cluster(key)
 }
foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' a_75_disc a_50_b_75_disc a_25_b_50_disc b_25_disc t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 , a(country) cluster(key)
 }
}

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' a_75_disc a_50_b_75_disc a_25_b_50_disc b_25_disc a_discovery_databook _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
 areg `lagnum'`var' a_75_disc a_50_b_75_disc a_25_b_50_disc b_25_disc a_discovery_databook t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

**********************************************************************************************
* Table A5: Effect of Onshore and Offshore Giant Oil Discoveries on Internal Armed Conflicts *
**********************************************************************************************
set more 1
foreach var of varlist war_type_3_location {
foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' onshore offshore _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
  test _b[onshore]-_b[offshore]=0
  display "H_0: onshore coef >= offshore coef. p-value = " 0.5*normal(sqrt(r(F)))
  }
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' onshore offshore t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
  test _b[onshore]=_b[offshore]
  display "H_0: onshore coef >= offshore coef. p-value = " 0.5*normal(sqrt(r(F)))
 }
}

set more 1
foreach var of varlist war_type_3_location {
 foreach lagnum of newlist led2 led4 led6 led8 led10 {
  areg `lagnum'`var' onshore offshore t_onshore_previous_10_years t_offshore_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 test _b[onshore]=_b[offshore]
 display "H_0: onshore coef >= offshore coef. p-value = " 0.5*normal(sqrt(r(F)))
 }
}

*log close 
************************************************************************************************************
* Figures 1 Effect of giant oilfield discovery on oil production, oil export, and internal armed conflicts.*
************************************************************************************************************

* rm figures.smcl
*log using figures


*rename ln_oil_gas_value_2005_ppp_pc ln_oil_value_2005_ppp_pc

drop led*ln_oil_value_2005_ppp_pc led*ln_oil_export_2005usd_pc led*war_type_3_location lag*ln_oil_value_2005_ppp_pc lag*war_type_3_location


set more 1
sort key year
tsset key year
foreach var of varlist ln_oil_value_2005_ppp_pc ln_oil_export_2005usd_pc war_type_3_location {
 foreach num of numlist 1(1)10 {
  by key : gen lag`num'`var' = l`num'.`var'
  by key : gen led`num'`var' = f`num'.`var'
 }
 foreach lagnum of numlist 10(-1)1 {
  areg lag`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 areg `var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 foreach lagnum of numlist 1(1)10 {
  areg led`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

foreach var of varlist war_type_3_location {
 foreach lagnum of numlist 10(-1)1 {
  areg lag`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
 areg `var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 foreach lagnum of numlist 1(1)10 {
  areg led`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
}




************************************************************************************************************
* Figures 2 Effect of giant oilfield discovery on oil production, oil export, and internal armed conflicts.*
************************************************************************************************************

set more 1
sort key year
tsset key year
foreach var of varlist ln_oil_value_2005_ppp_pc ln_oil_export_2005usd_pc war_type_3_location {
 foreach lagnum of numlist 10(-1)1 {
  areg lag`lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 areg `var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 foreach lagnum of numlist 1(1)10 {
  areg led`lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

foreach var of varlist war_type_3_location {
 foreach lagnum of numlist 10(-1)1 {
  areg lag`lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
 areg `var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 foreach lagnum of numlist 1(1)10 {
  areg led`lagnum'`var' discovery t_discovery_previous_10_years _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_type_3_previous_10_years>0 & m_war_type_3_previous_10_years!=., a(country) cluster(key)
 }
}

*********************************************************************************************
*Fiure 3: Effect of giant oilfield discovery on various measures of internal armed conflicts*
*********************************************************************************************
drop led*war_type_3_int_location led*war_type_3_4_location
set more 1
sort key year
tsset key year
foreach var of varlist  war_type_3_int_location war_type_3_4_location {
 foreach num of numlist 1(1)10 {
  by key : gen lag`num'`var' = l`num'.`var'
  by key : gen led`num'`var' = f`num'.`var'
 }
 foreach lagnum of numlist 10(-1)1 {
  areg lag`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
 areg `var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 foreach lagnum of numlist 1(1)10 {
  areg led`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946, a(country) cluster(key)
 }
}

foreach var of varlist war_type_3_location {
 foreach lagnum of numlist 10(-1)1 {
  areg lag`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_coups_previous_10_years>0 & m_coups_previous_10_years!=., a(country) cluster(key)
 }
 areg `var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_coups_previous_10_years>0 & m_coups_previous_10_years!=., a(country) cluster(key)
 foreach lagnum of numlist 1(1)10 {
  areg led`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_coups_previous_10_years>0 & m_coups_previous_10_years!=., a(country) cluster(key)
 }
}

foreach var of varlist war_type_3_location {
 foreach lagnum of numlist 10(-1)1 {
  areg lag`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_previous_10_years>0 & m_war_previous_10_years!=., a(country) cluster(key)
 }
 areg `var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_previous_10_years>0 & m_war_previous_10_years!=., a(country) cluster(key)
 foreach lagnum of numlist 1(1)10 {
  areg led`lagnum'`var' discovery _Iyear_1947- _Iyear_2008 if year>=1946 & m_war_previous_10_years>0 & m_war_previous_10_years!=., a(country) cluster(key)
 }
}
*log close
