%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file reproduces figure 4 in:  

% N. Gregory Mankiw and Ricardo Reis
% Sticky Information Versus Sticky Prices: A Proposal to Replace the New Keynesian Phillips Curve
% Quarterly Journal of Economics, 117 (4), 1295-1328, 2002

% and the IRFs resulting from Dynare

% Written by: Fabio Verona (fabio.verona@bof.fi) 
%             and
%             Maik H. Wolters (maik.wolters.ifw-kiel.de)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

data_IRF_MR_QJE;
MR_QJE_output_AR1=MR_QJE_output_AR1;MR_QJE_inflation_AR1=MR_QJE_inflation_AR1;

tt=length(MR_QJE_inflation_AR1);
figure('color','w')
subplot(2,1,2);
plot(1:tt,MR_QJE_inflation_AR1(1:tt),'ro-',1:tt,pi_eDM(1:tt),'bx-','LineWidth',2','MarkerSize',10);
legend('Mankiw Reis','Dynare','Orientation','horizontal','Location','BestOutside')
axis tight
title('IRF inflation, shock to the AR(1) aggregate demand')

subplot(2,1,1);
plot(1:tt,MR_QJE_output_AR1(1:tt),'ro-',1:tt,y_eDM(1:tt),'bx-','LineWidth',2,'MarkerSize',10);
axis tight
title('IRF output, shock to the AR(1) aggregate demand')



