//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Dynare code to replicate 
//
// N. Gregory Mankiw and Ricardo Reis
// Sticky Information Versus Sticky Prices: A Proposal to Replace the New Keynesian Phillips Curve
// Quarterly Journal of Economics, 117 (4), 1295-1328, 2002
//
// Written by: Fabio Verona (fabio.verona@bof.fi) 
//             and
//             Maik H. Wolters (maik.wolters.ifw-kiel.de)
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

@#define lags = [1:32]

var p pi y m dm z;

varexo eM eDM;
  
parameters lambda alpha rho_r;

lambda = 0.25;
alpha = 0.1;
rho_r = 0.5;

model(linear);
//Equations that drive sticky info
z = alpha*(y-y(-1))+pi;

//Inflation Definition
pi = p - p(-1);
dm = m - m(-1);

//Inflation Euler
pi = lambda*((alpha/(1-lambda))*y +  
 @#for lag in lags 
   +EXPECTATION(-@{lag})(z)*((1-lambda)^(@{lag}-1)) 
 @#endfor
);

//Nominal Demand
m = p + y;

//Persistent Shock Processes
//Choose whether you want to produce figure 1 or figure 4 in paper by //ing out 
//either the law of motion for m (lines 47 and 63) or for dm (lines 48 and 64). 
//m = m(-1) - eM;
dm = rho_r*dm(-1) - eDM;

end;

//check;
//steady;

shocks;
var eM; stderr 0.1;
var eDM; stderr 0.007;
end;

//stoch_simul(order=1,noprint,nograph,irf=40) y pi ;
stoch_simul(order=1,nomoments,noprint,nograph,irf=40) y pi ;

//differenceMRQJEexp1   % use in combination with line 47
differenceMRQJEAR1      % use in combination with line 48










