function sales = cfsales(salesrate,listingrate,growthrate,hstock)
% Calculate counterfactual sales series

% Series length
T = size(salesrate,1);
sales = zeros(T,1);

% Initial inventory (starting from steady state)
inv1 = hstock(1)*(listingrate(1)/(listingrate(1) + salesrate(1) + growthrate(1)));
invg_k = (inv1/hstock(1))*(1+growthrate(1));

% Main loop
for t=1:T
    
    % Compute next inventory level
    invg_k_next = ( listingrate(t) + ( 1 - ((listingrate(t) + salesrate(t))/2) )*(invg_k/(1+growthrate(t))) )/(1 + ((listingrate(t) + salesrate(t))/2));
    
    % Compute houses for sale
    forsale = ((invg_k/(1+growthrate(t))) + invg_k_next)/2;
    
    % Update inventory
    invg_k = invg_k_next;
    
    % Counterfactual sales volume
    sales(t) = salesrate(t)*forsale*hstock(t);
    
end
