function lambda = findlambda(y_x,coeff,rhs,dl)
% Solve for lambda parameter satisfying calibration equation

% Auxiliary parameters to pass
aux = [y_x; coeff; rhs];

% Lower bound
lb = 1 + ((1+coeff)/(rhs - coeff*log(y_x)));

% Check for solution
if (lb < 1)
    lambda = NaN;
    return;
end

% Upper bound
mdl = max(dl);
ub = (-log(mdl))/(log(y_x));
 
% Check for solution
if (lb > ub)
    lambda = NaN;
    return;
end
if (calibcrit(ub,aux) > 0)
    lambda = NaN;
    return;
end

% Find lambda satisfying calibration targets
lambda = fzero(@calibcrit,[lb ub],[],aux);
