function haz = hazard(paramvec,results,t)
% Calculate hazard function given parameters, model solution, and durations

% Unpackage parameters
idio = paramvec{1};
param = paramvec{2};
lambda = param(1);

% Unpackage results
x = results(1);
y = results(2);

% Calculate hazard function
haz = ( (1 - ((y/x)^lambda))*(exp(-t*idio{2}')*(idio{1}.*idio{2})) ... 
    + ((y/x)^lambda)*(exp(-t*(idio{2}.*(1 - idio{3}))')*(idio{1}.*idio{2}.*(1-idio{3}))) )./( ...
    (1 - ((y/x)^lambda))*(exp(-t*idio{2}')*idio{1}) ... 
    + ((y/x)^lambda)*(exp(-t*(idio{2}.*(1 - idio{3}))')*idio{1}) );
