% Plot empirical hazard function and fitted model hazard function

%% Load data and parameters, and solve model

% Filename to locate parameters
filename = 'paramendog2.mat';

% Include fixed effects (time and cohort)
hazfe = false;

% Maximum duration
maxdur = 80;

% Load empirical hazard function
hazdata = empiricalhazard(maxdur,hazfe);
dur = hazdata{1};
hazemp = hazdata{2};

% Load parameters
load(filename);

% Solve model
results = solvemodel(paramvec);

% Model-implied hazard function
haz = hazard(paramvec,results,dur);

% Scale as annual percentages
haz = 100*haz;
hazemp = 100*hazemp;

%% Generate figure

figure;
scatter(dur,hazemp,[],'blue');
hold on;
plot(dur,haz,'r');
legend({'Data';'Model'});
