function seriesadj = seasonadj(series)
% Seasonal adjustment (monthly)

% Number of observations
T = size(series,1);

% Mean of series
average = mean(series);

% Pad series to make divisible by 12
seriespad = [series; zeros(12-mod(T,12),1)];
TT = size(seriespad,1);
M = TT/12;

% Convert to a matrix
seasmat = reshape(seriespad,12,M);

% Number of observations for each month
MN = M*ones(12,1) - [zeros(12-(TT-T),1); ones(TT-T,1)];

% Percentage deviations from mean
seasmatpcdev = (1/average)*(seasmat - average*ones(12,M));
seasmatpcdev(13-(TT-T):12,M) = zeros(TT-T,1);

% Compute month means of percentage deviations
monthmeanpcdev = sum(seasmatpcdev,2)./MN;

% Seasonal adjustments (multiplicative)
adjfact = (1 - monthmeanpcdev)*ones(1,M);

% Adjusted series
seasadj = adjfact.*seasmat;
seriesadj = reshape(seasadj,TT,1);
seriesadj = seriesadj(1:T);
