clear all
set more off
set maxvar 10000
set matsize 2000
set varabbrev on

global REPLICATIONroot "D:\Dropbox\pesquisa\Winds\Replication"
cd "D:\Dropbox\pesquisa\Winds\Replication"

ssc install estout, replace

use "PolityData.dta", clear

// Drop observations outside the temporal window for merging with the trade shock data (1841-1905)
drop if year>1905
drop if year<1841

// Merge and drop
merge n:n country year using "dadosLPRED.dta"
sort country year
drop if _merge==1
drop _merge

// Drop variables not needed
drop polity2 autoc democ xrreg xrcomp xropen parreg parcomp

// Clean the data 
replace polity = . if polity<-11
replace xconst = . if xconst<0

// Exclude countries with few observations
egen count2_polity_bef = count(polity) if year<=1848, by(country)  
egen count_polity_bef = max(count2_polity_bef), by(country)
drop if count_polity_bef==. | count_polity_bef==0

// Select countries with trade shock data available
egen count_pt = count(predtrade), by(country)
drop if count_pt==. | count_pt==0
drop count_*
drop count2_*

// Save the cleaned dataset
save original_dataset.dta, replace

// Figure 6 - Frequency distribution 
histogram xconst, percent xscale(range(1 7)) xtitle("Executive Constraints") ytitle("%")
graph export "Results/Figure_6.png", replace

/////////////////////////////////////////////////// Table 1

// Selection of the temporal window  (Base sample: 1841-1900) 
drop if year > 1900 
drop if year < 1841

egen pol_bef = mean(polity) if year<=1860, by(country)
egen pol_aft = mean(polity) if year>=1881, by(country)

egen pt_bef = mean(predtrade) if year<=1860, by(country)
egen pt_aft = mean(predtrade) if year>=1881, by(country)

egen xconst_bef = mean(xconst) if year<=1860, by(country)
egen xconst_aft = mean(xconst) if year>=1881, by(country)

collapse (mean) pol_bef pol_aft pt_bef pt_aft xconst_bef xconst_aft, by(country)

// Differences between pre and post shock
gen dpol1 = pol_aft - pol_bef
gen shock = pt_aft - pt_bef
gen dxconst = xconst_aft - xconst_bef

// Interactions 
gen shock_polbef = shock * pol_bef
gen shock_xconstbef = shock * xconst_bef

drop if country == "Liberia" 

// OLS
reg xconst_aft shock xconst_bef shock_xconstbef, robust
estimates store OLS
global const_coef_ols = _b[_cons]
global shock_coef_ols = _b[shock]
global xconst_bef_coef_ols = _b[xconst_bef]
global shock_xconstbef_coef_ols = _b[shock_xconstbef]

// Tobit
tobit xconst_aft shock xconst_bef shock_xconstbef, ul(7) vce(robust)
estimates store Tobit
global const_coef_tbt = _b[_cons]
global shock_coef_tbt = _b[shock]
global xconst_bef_coef_tbt = _b[xconst_bef]
global sshock_xconstbef_coef_tbt = _b[shock_xconstbef]

// Probit with sample restriction
// Index: = 1 if difference > 0
gen imp_pol1 = 0
replace imp_pol1 = 1 if dpol1 > 0  
gen imp_xconst = 0
replace imp_xconst = 1 if dxconst > 0
preserve
drop if xconst_bef == 7 
probit imp_xconst shock xconst_bef shock_xconstbef, robust
restore
estimates store Probit
global const_coef_pbt = _b[_cons]
global shock_coef_pbt = _b[shock]
global xconst_bef_coef_pbt = _b[xconst_bef]
global shock_xconstbef_coeff_pbt = _b[shock_xconstbef]

// Table 1
esttab OLS Tobit Probit, se order(_cons xconst_bef shock  shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001)

// Save a .txt file
esttab OLS Tobit Probit using Results/Table_1.txt, se order(_cons xconst_bef shock shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001) replace

// Scatters

// Merge based on country codes
merge 1:n country using "CountryCode.dta"
drop _merge

// Figure 4 
twoway (function y = $const_coef_ols + $shock_coef_ols*x + $xconst_bef_coef_ols*(1) + $shock_xconstbef_coef_ols*x*(1), yline(0, lstyle(foreground)) range(0.6 1.2) xtitle("Trade Shock") ytitle("Executive Constraints, 1881-1900") legend(order(1 "Exec constr, 1841-1860 = 1" 2 "Exec constr, 1841-1860 = 3"))) (function y =  $const_coef_ols + $shock_coef_ols*x + $xconst_bef_coef_ols*(3) + $shock_xconstbef_coef_ols*x*(3), range(0.6 1.2))
graph export Results/Figure_4.png, replace

// Figure 7 - Before the shock
twoway (scatter xconst_bef shock, xtitle("Shock") ytitle("Executive Constraints") msize(vtiny) mlabel(code) mlabsize(vsmall) legend(off))
graph export Results/Figure_7_1.png, replace

// Figure 7 - After the shock
twoway (scatter xconst_aft shock, xtitle("Shock") ytitle("Executive Constraints") msize(vtiny) mlabel(code) mlabsize(vsmall) legend(off))
graph export Results/Figure_7_2.png, replace

export excel using dataset.xlsx, replace firstrow(variables)

/////////////////////////////////////////////////// Table 3

// 3.1 

// Selection of the temporal window 
clear
use original_dataset.dta, clear

drop if year > 1895 
drop if year < 1846

egen pol_bef = mean(polity) if year<=1860, by(country)
egen pol_aft = mean(polity) if year>=1881, by(country)

egen pt_bef = mean(predtrade) if year<=1860, by(country)
egen pt_aft = mean(predtrade) if year>=1881, by(country)

egen xconst_bef = mean(xconst) if year<=1860, by(country)
egen xconst_aft = mean(xconst) if year>=1881, by(country)

collapse (mean) pol_bef pol_aft pt_bef pt_aft xconst_bef xconst_aft, by(country)

// Differences between pre and post shock
gen dpol1 = pol_aft - pol_bef
gen shock = pt_aft - pt_bef
gen dxconst = xconst_aft - xconst_bef

// Interactions
gen shock_polbef = shock * pol_bef
gen shock_xconstbef = shock * xconst_bef
 
// OLS
reg xconst_aft shock xconst_bef shock_xconstbef, robust
estimates store OLS

// Tobit
tobit xconst_aft shock xconst_bef shock_xconstbef, ul(7) vce(robust)
estimates store Tobit

// Probit 
gen imp_pol1 = 0
replace imp_pol1 = 1 if dpol1 > 0  
gen imp_xconst = 0
replace imp_xconst = 1 if dxconst > 0
preserve
drop if xconst_bef == 7 
probit imp_xconst shock xconst_bef shock_xconstbef, robust
restore
estimates store Probit

// Table 3.1
esttab OLS Tobit Probit, se order(_cons xconst_bef shock shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001)

// Save a .txt file
esttab OLS Tobit Probit using Results/Table_3_1.txt, se order(_cons xconst_bef shock shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001) replace

// 3.2

// Selection of the temporal window 
clear
use original_dataset.dta, clear

drop if year > 1905 
drop if year < 1841

egen pol_bef = mean(polity) if year<=1865, by(country)
egen pol_aft = mean(polity) if year>=1881, by(country)

egen pt_bef = mean(predtrade) if year<=1865, by(country)
egen pt_aft = mean(predtrade) if year>=1881, by(country)

egen xconst_bef = mean(xconst) if year<=1865, by(country)
egen xconst_aft = mean(xconst) if year>=1881, by(country)

collapse (mean) pol_bef pol_aft pt_bef pt_aft xconst_bef xconst_aft, by(country)

// Differences between pre and post shock
gen dpol1 = pol_aft - pol_bef
gen shock = pt_aft - pt_bef
gen dxconst = xconst_aft - xconst_bef

// Interactions
gen shock_polbef = shock * pol_bef
gen shock_xconstbef = shock * xconst_bef

drop if country == "Liberia" 

// OLS
reg xconst_aft shock xconst_bef shock_xconstbef, robust
estimates store OLS

// Tobit
tobit xconst_aft shock xconst_bef shock_xconstbef, ul(7) vce(robust)
estimates store Tobit

// Probit 
gen imp_pol1 = 0
replace imp_pol1 = 1 if dpol1 > 0  
gen imp_xconst = 0
replace imp_xconst = 1 if dxconst > 0
preserve
drop if xconst_bef == 7 
probit imp_xconst shock xconst_bef shock_xconstbef, robust
restore
estimates store Probit

// Table 3.2
esttab OLS Tobit Probit, se order(_cons xconst_bef shock shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001)

// Save a .txt file
esttab OLS Tobit Probit using Results/Table_3_2.txt, se order(_cons xconst_bef shock shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001) replace

///////////////////////////////////////////////////Table 4

// 4.1 

// Selection of the temporal window 
clear
use original_dataset.dta, clear
drop if year > 1900
drop if year < 1846

egen pol_bef = mean(polity) if year<=1865, by(country)
egen pol_aft = mean(polity) if year>=1881, by(country)

egen pt_bef = mean(predtrade) if year<=1865, by(country)
egen pt_aft = mean(predtrade) if year>=1881, by(country)

egen xconst_bef = mean(xconst) if year<=1865, by(country)
egen xconst_aft = mean(xconst) if year>=1881, by(country)

collapse (mean) pol_bef pol_aft pt_bef pt_aft xconst_bef xconst_aft, by(country)

// Differences between pre and post shock
gen dpol1 = pol_aft - pol_bef
gen shock = pt_aft - pt_bef
gen dxconst = xconst_aft - xconst_bef

// Interactions
gen shock_polbef = shock * pol_bef
gen shock_xconstbef = shock * xconst_bef

// OLS
reg xconst_aft shock xconst_bef shock_xconstbef, robust
estimates store OLS

// Tobit
tobit xconst_aft shock xconst_bef shock_xconstbef, ul(7) vce(robust)
estimates store Tobit

// Probit 
gen imp_pol1 = 0
replace imp_pol1 = 1 if dpol1 > 0  
gen imp_xconst = 0
replace imp_xconst = 1 if dxconst > 0
preserve
drop if xconst_bef == 7 
probit imp_xconst shock xconst_bef shock_xconstbef, robust
restore
estimates store Probit

// Table 4.1
esttab OLS Tobit Probit, se order(_cons xconst_bef shock  shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001)

// Save a .txt file
esttab OLS Tobit Probit using Results/Table_4_1.txt, se order(_cons xconst_bef shock shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001) replace

// 4.2

clear
use original_dataset.dta, clear
drop if year > 1895 
drop if year < 1846

egen pol_bef = mean(polity) if year<=1865, by(country)
egen pol_aft = mean(polity) if year>=1876, by(country)

egen pt_bef = mean(predtrade) if year<=1865, by(country)
egen pt_aft = mean(predtrade) if year>=1876, by(country)

egen xconst_bef = mean(xconst) if year<=1865, by(country)
egen xconst_aft = mean(xconst) if year>=1876, by(country)

collapse (mean) pol_bef pol_aft pt_bef pt_aft xconst_bef xconst_aft, by(country)

// Differences between pre and post shock
gen dpol1 = pol_aft - pol_bef
gen shock = pt_aft - pt_bef
gen dxconst = xconst_aft - xconst_bef

// Interactions
gen shock_polbef = shock * pol_bef
gen shock_xconstbef = shock * xconst_bef

// OLS
reg xconst_aft shock xconst_bef shock_xconstbef, robust
estimates store OLS

// Tobit
tobit xconst_aft shock xconst_bef shock_xconstbef, ul(7) vce(robust)
estimates store Tobit

// Probit 
gen imp_pol1 = 0
replace imp_pol1 = 1 if dpol1 > 0  
gen imp_xconst = 0
replace imp_xconst = 1 if dxconst > 0
preserve
drop if xconst_bef == 7 
probit imp_xconst shock xconst_bef shock_xconstbef, robust
restore
estimates store Probit

// Table 4.2
esttab OLS Tobit Probit, se order(_cons xconst_bef shock  shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001)

// Save a .txt file
esttab OLS Tobit Probit using Results/Table_4_2.txt, se order(_cons xconst_bef shock shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001) replace

/////////////////////////////////////////////////// Table 5

// 5.1 

clear
use original_dataset.dta, clear
drop if year > 1890
drop if year < 1851

egen pol_bef = mean(polity) if year<=1865, by(country)
egen pol_aft = mean(polity) if year>=1876, by(country)

egen pt_bef = mean(predtrade) if year<=1865, by(country)
egen pt_aft = mean(predtrade) if year>=1876, by(country)

egen xconst_bef = mean(xconst) if year<=1865, by(country)
egen xconst_aft = mean(xconst) if year>=1876, by(country)

collapse (mean) pol_bef pol_aft pt_bef pt_aft xconst_bef xconst_aft, by(country)

// Differences between pre and post shock
gen dpol1 = pol_aft - pol_bef
gen shock = pt_aft - pt_bef
gen dxconst = xconst_aft - xconst_bef

// Interactions
gen shock_polbef = shock * pol_bef
gen shock_xconstbef = shock * xconst_bef

// OLS
reg xconst_aft shock xconst_bef shock_xconstbef, robust
estimates store OLS

// Tobit
tobit xconst_aft shock xconst_bef shock_xconstbef, ul(7) vce(robust)
estimates store Tobit

// Probit 
gen imp_pol1 = 0
replace imp_pol1 = 1 if dpol1 > 0  
gen imp_xconst = 0
replace imp_xconst = 1 if dxconst > 0
preserve
drop if xconst_bef == 7 
probit imp_xconst shock xconst_bef shock_xconstbef, robust
restore
estimates store Probit

// Table 5.1
esttab OLS Tobit Probit, se order(_cons xconst_bef shock  shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001)

// Save a .txt file
esttab OLS Tobit Probit using Results/Table_5_1.txt, se order(_cons xconst_bef shock shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001) replace

// 5.2

clear
use original_dataset.dta, clear
drop if year > 1895 
drop if year < 1851

egen pol_bef = mean(polity) if year<=1865, by(country)
egen pol_aft = mean(polity) if year>=1881, by(country)

egen pt_bef = mean(predtrade) if year<=1865, by(country)
egen pt_aft = mean(predtrade) if year>=1881, by(country)

egen xconst_bef = mean(xconst) if year<=1865, by(country)
egen xconst_aft = mean(xconst) if year>=1881, by(country)

collapse (mean) pol_bef pol_aft pt_bef pt_aft xconst_bef xconst_aft, by(country)

// Differences between pre and post shock
gen dpol1 = pol_aft - pol_bef
gen shock = pt_aft - pt_bef
gen dxconst = xconst_aft - xconst_bef

// Interactions
gen shock_polbef = shock * pol_bef
gen shock_xconstbef = shock * xconst_bef

// OLS
reg xconst_aft shock xconst_bef shock_xconstbef, robust
estimates store OLS

// Tobit
tobit xconst_aft shock xconst_bef shock_xconstbef, ul(7) vce(robust)
estimates store Tobit

// Probit
gen imp_pol1 = 0
replace imp_pol1 = 1 if dpol1 > 0  
gen imp_xconst = 0
replace imp_xconst = 1 if dxconst > 0
preserve
drop if xconst_bef == 7 
probit imp_xconst shock xconst_bef shock_xconstbef, robust
restore
estimates store Probit

// Table 5.2
esttab OLS Tobit Probit, se order(_cons xconst_bef shock  shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001)

// Save a .txt file
esttab OLS Tobit Probit using Results/Table_5_2.txt, se order(_cons xconst_bef shock shock_xconstbef) mtitle("OLS" "Tobit" "Probit") nogaps compress star(* 0.05 ** 0.01 *** 0.001) replace
