function [psi x Delta delta] = equilaux(epsilon,eta,lambda,mu,s)

% Find z root
z = zroot(mu,epsilon,eta);

% Find quantity ratio
chi = findchi(mu,epsilon,eta);

% Calculate psi coefficient
psi = 1 - (((1-s)*(1 - ((eta-1)/(epsilon-1))*((mu^(1-epsilon) - 1)/(mu^(1-eta) - 1))))/...
    ((1+z) + s*((mu^(1-epsilon) - 1) + z*(mu^(1-eta) - 1))));

% Calculate real marginal cost (reciprocal of average markup)
x = (((epsilon-1) + z*(eta-1))/(epsilon + z*eta))*((lambda*((1+z) + ...
    s*((mu^(1-epsilon) - 1) + z*(mu^(1-eta) - 1))))^(1/(epsilon-1)));

% Price distortions
Delta = ((lambda*((1+z) + s*((mu^(1-epsilon) - 1) + z*(mu^(1-eta) - 1))))^(epsilon/(epsilon-1)))/...
    (lambda*((1+z) + s*((mu^(-epsilon) - 1) + z*(mu^(-eta) - 1))));

% Cyclicality in price distortions
delta = ((s*chi*epsilon*(1-mu))/(s*chi + (1-s))) + ...
    ((s*chi*mu + (1-s))/(s*chi + (1-s)))*...
    (((1/(epsilon-1))*((epsilon-1)*(mu^(-epsilon) - 1) - epsilon*(mu^(1-epsilon) - 1) ) + ...
    (z/(eta-1))*((eta-1)*(mu^(-eta) - 1) - eta*(mu^(1-eta) - 1)))/...
    (((mu^(1-eta) - 1)/(eta-1)) - ((mu^(1-epsilon) - 1)/(epsilon-1))));
