function [epsilon eta lambda sigma] = matchtargets(muT,chiT,sT,sbarT)
% Match parameters and calibration targets

% Find elasticities epsilon and eta
elast0 = [3; 20];
elast = fminsearch(@critfunc,elast0,[],muT,chiT);
epsilon = elast(1);
eta = elast(2);

% Calculate equilibrium
mu = findmu(epsilon,eta);
z = zroot(mu,epsilon,eta);

% Find lambda
lambda = ((1 + sT*(mu^(1-eta) - 1))^((eta-epsilon)/(1-eta)))/(z + ((1 + sT*(mu^(1-eta) - 1))^((eta-epsilon)/(1-eta))));

% Find sigma
sigma = sbarT/sT;
