function res = resultant(mu,epsilon,eta)
% Return resultant of quadratic and cubic equations for specified mu value
% and given parameters

% Coefficients of cubic equation
a = [ (eta-1), ...
    (epsilon-1)*((1-mu^(2*eta-epsilon))/(1-mu^eta)) + 2*(eta-1)*(((mu^(eta-epsilon)) - mu^eta)/(1-mu^eta)) , ...
    2*(epsilon-1)*(((mu^(eta-epsilon)) - mu^(2*eta-epsilon))/(1-mu^eta)) + (eta-1)*(((mu^(2*(eta-epsilon))) - mu^eta)/(1-mu^eta)) , ...
    (epsilon-1)*(((mu^(2*(eta-epsilon))) - mu^(2*eta-epsilon))/(1-mu^eta)) ];
a = fliplr(a);

% Coefficients of quadratic equation
b = [ eta*(eta-1) , ...
    -( (epsilon*(eta-1) - eta*(epsilon-1)*mu)*((1-mu^(eta-epsilon))/(1-mu)) - epsilon*(eta-1) - eta*(epsilon-1) ), ...
    epsilon*(epsilon-1)*(mu^(eta-epsilon)) ];
b = fliplr(b);

% Set up resultant matrix
M = [a 0; 0 a; b 0 0; 0 b 0; 0 0 b];

% Return determinant
res = det(M);
