function crit = critfunc(elast,muT,chiT)
% Criterion function for matching parameters and calibration targets

% Elasticities
epsilon = elast(1);
eta = elast(2);

% Solve for stationary equilibrium
mu = findmu(epsilon,eta);
chi = findchi(mu,epsilon,eta);

% Value of criterion function
crit = (log(mu/muT))^2 + (log(chi/chiT))^2;
