function chi = findchi(mu,epsilon,eta)
% Find equilibrium value of chi for given parameters epsilon and eta
% assuming mu has already been found

% Get z root
z = zroot(mu,epsilon,eta);

% Quantity ratio
chi = (mu^(-epsilon))*((1 + (mu^(epsilon-eta))*z)/(1+z));
