function z = zroot(mu,epsilon,eta)
% Finds root corresponding to lower branch of quadratic solution

% Coefficients of quadratic equation
b = [ eta*(eta-1) , ...
    -( (epsilon*(eta-1) - eta*(epsilon-1)*mu)*((1-mu^(eta-epsilon))/(1-mu)) - epsilon*(eta-1) - eta*(epsilon-1) ), ...
    epsilon*(epsilon-1)*(mu^(eta-epsilon)) ];

% Return solution using quadratic formula
z = (-b(2) - sqrt(b(2)^2 - 4*b(3)*b(1)))/(2*b(1));
