function s = finds(mu,epsilon,eta,lambda)
% Find equilibrium value of s for given parameters epsilon, eta and lambda
% assuming mu has already been found

% Get z root
z = zroot(mu,epsilon,eta);

% Upper and lower bounds for two-price equilibrium
lambdalow = 1/(1 + (mu^(epsilon-eta))*z);
lambdaup = 1/(1+z);

% Sales fraction
if (lambda > lambdalow) && (lambda < lambdaup)
    s = (((lambda/(1-lambda))*z)^(-(eta-1)/(eta-epsilon)) - 1)/(mu^(1-eta) - 1);
else
    s = (lambda <= lambdalow);
end
