function [Phi Theta] = solvedyn(epsilon,eta,lambda,sigma,beta,thetac,thetah,alpha,gamma,varsigma,phip,phiw,p)
% Solve for dynamics of sales model

% Set path
path(path,'../../Matlab/McCallumToolkit');

% Find steady state
[mu chi s] = solvess(epsilon,eta,lambda,sigma);

% Obtain characteristics of equilibrium and coefficients
[psi x Delta delta] = equilaux(epsilon,eta,lambda,mu,s);
psibar = sigma*psi;
xi = 1/(1-x);
kappa = ((1-phip)*(1-beta*phip))/phip;

% Set up dynamic equations

% Endogenous variables
ipibar = 1; % aggregate inflation
iYbar = ipibar + 1; % aggregate output
ii = iYbar + 1; % nominal interest rate
iw = ii + 1; % real wage
iwstar = iw + 1; % desired real wage
ipiW = iwstar + 1; % wage inflation
irho = ipiW + 1; % non-sale-sector price level to average normal price
ix = irho + 1; % real marginal cost in sale sector (defined using aggregate price level)
iY = ix + 1; % value-added of sale sector
iQ = iY + 1; % physical output of sale sector
iMg = iQ + 1; % growth rate of money supply
ny = iMg; % total number of non-predetermined endogenous variables
iYbarl = ny + 1; % lagged aggregate output
iwl = iYbarl + 1; % lagged real wage
irhol = iwl + 1; % lagged relative price
ixl = irhol + 1; % lagged real marginal cost
iMgl = ixl + 1; % lagged money growth rate
nx = iMgl; % total number of endogenous variables
nk = nx - ny; % total number of predetermined endogenous variables

% Shocks
kmp = 1; % monetary-policy shock
nz = kmp; % total number of exogenous shocks

% Equations
ja = 1;
jb = ja + 1;
jc = jb + 1;
jd = jc + 1;
je = jd + 1;
jf = je + 1;
jg = jf + 1;
jh = jg + 1;
ji = jh + 1;
jj = ji + 1;
jk = jj + 1;
jYbarl = jk + 1;
jwl = jYbarl + 1;
jrhol = jwl + 1;
jxl = jrhol + 1;
jMgl = jxl + 1;
ne = jMgl; % total number of equations

% Create matrices
A = zeros(ne,nx);
B = zeros(ne,nx);
C = zeros(ne,nz);
D = zeros(nz,nz);

% Equation (a)
B(ja,ipibar) = -1;
A(ja,ipibar) = -beta;
B(ja,ix) = (kappa + (1+beta)*psibar)/(1-psibar);
B(ja,ixl) = -psibar/(1-psibar);
A(ja,ix) = (beta*psibar)/(1-psibar);
B(ja,irho) = ((1-sigma)/(1-psibar))*(kappa+(1+beta));
B(ja,irhol) = -((1-sigma)/(1-psibar));
A(ja,irho) = beta*((1-sigma)/(1-psibar));

% Equation (b)
B(jb,irho) = -(1+beta) - (kappa/(1+xi*gamma))*((gamma*(1-psi)*(epsilon - (1-sigma)*delta) + (1-psibar) + (1-sigma)*(xi*gamma))/(1-psibar));
A(jb,irho) = -beta;
B(jb,irhol) = 1;
B(jb,ix) = (kappa/(1+xi*gamma))*(gamma*((1-psi)*delta + psi*epsilon - xi)/(1-psibar));

% Equation (c)
B(jc,iY) = -1;
B(jc,iYbar) = 1;
B(jc,irho) = (epsilon*(1-psi))*((1-sigma)/(1-psibar));
B(jc,ix) = -(epsilon*psi)*((1-sigma)/(1-psibar));

% Equation (d)
B(jd,iY) = -1;
B(jd,iQ) = 1;
B(jd,ix) = delta*((1-psi)/(1-psibar));
B(jd,irho) = (delta*(1-sigma))*((1-psi)/(1-psibar));

% Equation (e)
B(je,ix) = -1;
B(je,iw) = 1;
B(je,iQ) = gamma;

% Equation (f)
B(jf,ipiW) = -1;
A(jf,ipiW) = -beta;
B(jf,iwstar) = ((1-phiw)*(1-beta*phiw)/phiw)*(1/(1+(varsigma/thetah)));
B(jf,iw) = -((1-phiw)*(1-beta*phiw)/phiw)*(1/(1+(varsigma/thetah)));

% Equation (g)
B(jg,iwstar) = -1;
B(jg,iYbar) = (1/thetac) + (1/(alpha*thetah))*(Delta/(sigma + (1-sigma)*Delta));
B(jg,iQ) = (1/(alpha*thetah))*(sigma/(sigma + (1-sigma)*Delta));
B(jg,iY) = -Delta*(1/(alpha*thetah))*(sigma/(sigma + (1-sigma)*Delta));

% Equation (h)
B(jh,iw) = -1;
B(jh,iwl) = 1;
B(jh,ipiW) = 1;
B(jh,ipibar) = -1;

% Equation (i)
B(ji,iYbar) = -1;
A(ji,iYbar) = -1;
B(ji,ii) = -thetac;
A(ji,ipibar) = -thetac;

% Equation (j)
B(jj,iYbar) = -1;
B(jj,iYbarl) = 1;
B(jj,iMg) = 1;
B(jj,ipibar) = -1;

% Equation (k)
B(jk,iMg) = -1;
B(jk,iMgl) = p;
C(jk,kmp) = (1-p);
D(kmp,kmp) = 0;

% Definitional equation: iYbarl
A(jYbarl,iYbarl) = 1;
B(jYbarl,iYbar) = 1;

% Definitional equation: iwl
A(jwl,iwl) = 1;
B(jwl,iw) = 1;

% Definitional equation: irhol
A(jrhol,irhol) = 1;
B(jrhol,irho) = 1;

% Definitional equation: ixl
A(jxl,ixl) = 1;
B(jxl,ix) = 1;

% Definitional equation: iMgl
A(jMgl,iMgl) = 1;
B(jMgl,iMg) = 1;

% Obtain the reduced form of the model
[M N P Q] = solvek(A,B,C,D,nk);

% Put solution into state-space form
ns = nx + nz;
Phi = [zeros(ns,ny) [M*P; P; zeros(nz,nk)] [(M*Q + N*D); Q; D]];
Theta = [N; zeros(nk,nz); eye(nz)];
