// *********************************************************************************************************************
// * 01 Run
// * This script is master script that uns tables and figures from paper and appendixes. 

//  First set global paths running 00_init.do 
//  Make sures that the clean data files exist. Otherwise run: 
// do 001_cleaning_agg_data.do
// do 001_cleaning_transactions.do

// Global variables:
// market_seg: -1 for all segments, 0 for segment 0, 1 for segment 1, 2 for segment 2, -2 for all segments except 2, see in each file. 
// prop_type: 1 to 15 for property types, after 6 combinations, see file 01_basic_regs/01_replic_main_table_seg.do
// placebo_border: 0 for no placebo, -2000, -3000, -4000, -5000, -6000 for placebo borders
// crisis_removed: 0 for no crisis removed, 1 for crisis removed
// sample_number: for main sample estimation, see other numbers in 01_basic_regs/01_replic_main_table_seg.do
// default_distances: 0 for default distances, 1 for extended distances thresholds, defined in 01_basic_regs/06_replic_main_table_seg_dist.do
// yearmonthfe: 0 for no yearmonth fixed effects, 1 for yearmonth fixed effects
// crisis_start: crisis start date
// crisis_end: crisis end date

// *********************************************************************************************************************
// * Config 
// default global variables used in most of the exercises
global houseprice_tier = 0
global prop_type = -1 
global crisis_removed = 0 
global market_seg = 0
global default_distances = 1
global yearmonthfe = 0
global placebo_border = 0
global houseprice_tier = 0
global hazard_off = 0
global sample_number = "sample3"
global dom_on = 1

global dominant_log = 0
// *********************************************************************************************************************
// * 02 Figure 1

global date_final = "ym(2011,08)" // this is  aug - 2011
di "Date final: `date_final'"

do "$dofiles/02_figure1.do"

// *********************************************************************************************************************

do "$dofiles/03_table1.do"

do "$dofiles/04_table2_hazard.do" // take a long time, uncomment to run

// *********************************************************************************************************************
// * 05 Table A1 Descriptive statistics for samples 

do "$dofiles/05_tableA3_run.do"

// *********************************************************************************************************************
global sample_number = "sample3"

do "$dofiles/06_table_A4_x.do"

do "$dofiles/07_tableA5_sales_leases.do"

do "$dofiles/08_tableA6_pdom.do"

do "$dofiles/09_tableA7_crisis.do" // take a long time, uncomment to run

// *********************************************************************************************************************
global crisis_removed = 0

do "$dofiles/10_tableA8_placebo.do"

// *********************************************************************************************************************
global default_distances = 1

do "$dofiles/11_tableA9_bto_btr.do"  

do "$dofiles/12_tableA10_hazard_period.do" // take a long time, uncomment to run

// *********************************************************************************************************************
glo sample_number = "sample3"

do "$dofiles/13_tableA11_prop_types.do"

do "$dofiles/14_tableA12_price_period.do"

// *********************************************************************************************************************